/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.ServerKeyExchange;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;
import java.security.interfaces.RSAPublicKey;

final class RSAServerKeyExchange
extends ServerKeyExchange {
    protected RSAServerKeyExchange(ClientHandShaker clientHandShaker, byte[] byArray) throws IOException {
        super(clientHandShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ RSAServerKeyExchange");
        }
    }

    protected RSAServerKeyExchange(ServerHandShaker serverHandShaker, int n) throws IOException {
        super(serverHandShaker, n);
    }

    protected void generateParamsAndSig(XDROutputStream xDROutputStream) throws IOException {
        RSAPublicKey rSAPublicKey = ((ServerHandShaker)this.handShaker).generateTempRSAPubKey();
        byte[] byArray = rSAPublicKey.getModulus().toByteArray();
        byte[] byArray2 = rSAPublicKey.getPublicExponent().toByteArray();
        xDROutputStream.writeVector(2, byArray);
        xDROutputStream.writeVector(2, byArray2);
    }

    protected void verifyParamsSig(XDRInputStream xDRInputStream, XDROutputStream xDROutputStream) throws IOException {
        byte[] byArray = xDRInputStream.readVector(2);
        byte[] byArray2 = xDRInputStream.readVector(2);
        ((ClientHandShaker)this.handShaker).setServerEncryptionKey(byArray, byArray2);
        xDROutputStream.writeVector(2, byArray);
        xDROutputStream.writeVector(2, byArray2);
    }
}

