/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.ProtocolUnitInputStream;
import com.dstc.security.ssl.ProtocolUnitOutputStream;
import com.dstc.security.ssl.SSLMac;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;

final class SSLContext {
    protected static final int CLIENT = 0;
    protected static final int SERVER = 1;
    protected static final int READ = 0;
    protected static final int WRITE = 1;
    private HandShaker handShaker;
    private ProtocolUnitInputStream pis;
    private ProtocolUnitOutputStream pos;
    private Cipher[] cipher = new Cipher[2];
    private MessageDigest[] mac = new MessageDigest[2];
    private byte[][] macSecret = new byte[2][];
    private long[] seqNum = new long[2];
    private int[] blockSize = new int[2];
    private int[] macSize = new int[2];
    private int[] keyLength = new int[2];
    private int[] expKeyLength = new int[2];
    private int[] padSize = new int[2];
    private String[] cipherAlgName = new String[2];
    private String[] macAlgName = new String[2];
    private boolean[] isBlockCipher = new boolean[2];
    private CipherSpec pendingCipherSpec;
    private SSLMac sslMac;

    SSLContext(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.pos = new ProtocolUnitOutputStream(this, new XDROutputStream(outputStream));
        this.pis = new ProtocolUnitInputStream(this, new XDRInputStream(inputStream));
    }

    private byte[] decrypt(byte by, byte[] byArray) throws IOException {
        byte by2;
        if (Debug.debug >= 3) {
            Debug.debug("cipherText.length: " + byArray.length);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CipherInputStream cipherInputStream = new CipherInputStream(byteArrayInputStream, this.cipher[0]);
        byte[] byArray2 = new byte[byArray.length];
        int n = cipherInputStream.read(byArray2);
        if (Debug.debug >= 3) {
            Debug.debug("decrypted: ", byArray2);
            Debug.debug("done: " + n);
        }
        byte by3 = by2 = this.isBlockCipher[0] ? byArray2[byArray2.length - 1] : (byte)0;
        if (Debug.debug >= 3) {
            Debug.debug("padlength: " + by2);
            Debug.debug("macSize[READ]: " + this.macSize[0]);
            Debug.debug("isBlockCipher[READ]: " + this.isBlockCipher[0]);
        }
        byte[] byArray3 = this.isBlockCipher[0] ? new byte[byArray2.length - this.macSize[0] - (by2 + 1)] : new byte[byArray2.length - this.macSize[0]];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray3.length);
        if (Debug.debug >= 3) {
            Debug.debug("retval.length: " + byArray3.length);
        }
        byte[] byArray4 = new byte[this.macSize[0]];
        System.arraycopy(byArray2, byArray3.length, byArray4, 0, byArray4.length);
        if (!Arrays.equals(byArray4, this.generateMac(by, byArray3, 0))) {
            throw new SSLProtocolException("Bad mac received");
        }
        return byArray3;
    }

    protected byte[] decryptAndVerifyMac(byte by, byte[] byArray) throws SSLProtocolException, IOException {
        if (this.cipher[0] == null) {
            return byArray;
        }
        byte[] byArray2 = this.decrypt(by, byArray);
        return byArray2;
    }

    private byte[] encrypt(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, this.cipher[1]);
        cipherOutputStream.write(byArray);
        cipherOutputStream.write(byArray2);
        if (this.isBlockCipher[1]) {
            int n = byArray.length + byArray2.length;
            int n2 = (n + 1) % this.cipher[1].getBlockSize();
            int n3 = n2 == 0 ? 0 : this.cipher[1].getBlockSize() - n2;
            byte[] byArray3 = new byte[n3];
            cipherOutputStream.write(byArray3);
            cipherOutputStream.write((byte)n3);
            if (Debug.debug >= 3) {
                Debug.debug("padLength: " + n3);
                Debug.debug("rawAndMacLength: " + n);
            }
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        if (Debug.debug >= 3) {
            Debug.debug("raw: ", byArray);
            Debug.debug("macBytes: ", byArray2);
            Debug.debug("cipherText: ", byArray4);
        }
        return byArray4;
    }

    private byte[] generateMac(byte by, byte[] byArray, int n) {
        int n2 = n;
        long l = this.seqNum[n2];
        this.seqNum[n2] = l + 1L;
        return this.sslMac.macMessage(this.macSecret[n], SSLContext.getSequenceNumber(l), by, byArray, this.handShaker.getProtocolVersion());
    }

    HandShaker getHandShaker() {
        return this.handShaker;
    }

    ProtocolUnitInputStream getInputStream() {
        return this.pis;
    }

    SSLMac getMac() {
        return this.sslMac;
    }

    ProtocolUnitOutputStream getOutputStream() {
        return this.pos;
    }

    protected String getPendingKeyXAlgName() {
        return this.pendingCipherSpec.keyXAlgName;
    }

    private static byte[] getSequenceNumber(long l) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray[n] = (byte)(l >> 8 * (7 - n) & 0xFFL);
            ++n;
        }
        return byArray;
    }

    protected boolean isPendingExportable() {
        return this.pendingCipherSpec.isExportable;
    }

    protected byte[] macAndEncrypt(byte by, byte[] byArray) throws IOException {
        if (this.cipher[1] != null) {
            byte[] byArray2 = this.generateMac(by, byArray, 1);
            byte[] byArray3 = this.encrypt(byArray, byArray2);
            return byArray3;
        }
        return byArray;
    }

    protected void nextHandShake(SSLProtocolUnit sSLProtocolUnit) throws IOException {
        this.handShaker.nextMessage(sSLProtocolUnit);
    }

    protected void setHandShaker(HandShaker handShaker) {
        this.handShaker = handShaker;
        this.handShaker.startPreEmptor();
    }

    protected synchronized void setKeyData(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws SSLException {
        try {
            IvParameterSpec ivParameterSpec;
            SecretKeySpec secretKeySpec;
            Object object;
            if (Debug.debug >= 3) {
                Debug.debug("keyBlock: ", byArray);
            }
            this.macAlgName[n2] = this.pendingCipherSpec.macAlgName;
            this.cipherAlgName[n2] = this.pendingCipherSpec.cipherAlgName;
            this.padSize[n2] = this.pendingCipherSpec.padSize;
            this.macSize[n2] = this.pendingCipherSpec.macSize;
            this.blockSize[n2] = this.pendingCipherSpec.blockSize;
            this.keyLength[n2] = this.pendingCipherSpec.keyLength;
            this.expKeyLength[n2] = this.pendingCipherSpec.expKeyLength;
            this.isBlockCipher[n2] = this.pendingCipherSpec.isBlockCipher;
            if (this.isPendingExportable()) {
                object = MessageDigest.getInstance("MD5");
                ((MessageDigest)object).update(byArray, this.macSize[n2] * 2 + n * this.keyLength[n2], this.keyLength[n2]);
                if (n == 0) {
                    ((MessageDigest)object).update(byArray3);
                }
                ((MessageDigest)object).update(byArray2);
                if (n == 1) {
                    ((MessageDigest)object).update(byArray3);
                }
                secretKeySpec = new SecretKeySpec(((MessageDigest)object).digest(), 0, this.expKeyLength[n2], this.cipherAlgName[n2]);
                if (n == 0) {
                    ((MessageDigest)object).update(byArray3);
                }
                ((MessageDigest)object).update(byArray2);
                if (n == 1) {
                    ((MessageDigest)object).update(byArray3);
                }
                ivParameterSpec = new IvParameterSpec(((MessageDigest)object).digest(), 0, this.blockSize[n2]);
            } else {
                secretKeySpec = new SecretKeySpec(byArray, this.macSize[n2] * 2 + n * this.keyLength[n2], this.keyLength[n2], this.cipherAlgName[n2]);
                ivParameterSpec = new IvParameterSpec(byArray, 2 * (this.macSize[n2] + this.keyLength[n2]) + n * this.blockSize[n2], this.blockSize[n2]);
            }
            if (Debug.debug >= 3) {
                Debug.debug("key: ", secretKeySpec.getEncoded());
                Debug.debug("iv: ", ivParameterSpec.getIV());
            }
            object = this.isBlockCipher[n2] ? "/CBC/NoPadding" : "";
            String string = String.valueOf(this.cipherAlgName[n2]) + (String)object;
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.cipherAlgName[n2]);
            this.cipher[n2] = Cipher.getInstance(string);
            int n3 = n2 == 0 ? 2 : 1;
            this.cipher[n2].init(n3, (Key)secretKeyFactory.translateKey(secretKeySpec), ivParameterSpec);
            this.macSecret[n2] = new byte[this.macSize[n2]];
            System.arraycopy(byArray, n * this.macSize[n2], this.macSecret[n2], 0, this.macSize[n2]);
            this.mac[n2] = MessageDigest.getInstance(this.macAlgName[n2]);
            this.seqNum[n2] = 0L;
            if (Debug.debug >= 1) {
                Debug.debug("cipher changed");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SSLException(exception.getMessage());
        }
    }

    protected void setPendingCipherSpec(byte[] byArray) {
        this.pendingCipherSpec = new CipherSpec(byArray);
        this.sslMac = new SSLMac(this.pendingCipherSpec.macAlgName, this.pendingCipherSpec.padSize);
    }

    class CipherSpec {
        protected String keyXAlgName;
        protected String cipherAlgName;
        protected String macAlgName;
        protected boolean isBlockCipher;
        protected boolean isExportable;
        protected int macSize;
        protected int blockSize;
        protected int keyLength;
        protected int expKeyLength;
        protected int padSize;
        protected String suiteName;

        CipherSpec(byte[] byArray) {
            int n = CipherSuites.getIndex(byArray);
            this.keyXAlgName = CipherSuites.keyXAlgName[n];
            this.suiteName = CipherSuites.suiteName[n];
            this.isExportable = CipherSuites.isExportable[n];
            this.cipherAlgName = CipherSuites.cipherAlgName[n];
            this.isBlockCipher = CipherSuites.isBlockCipher[n];
            this.keyLength = CipherSuites.keyLength[n];
            this.expKeyLength = CipherSuites.expKeyLength[n];
            this.blockSize = CipherSuites.blockSize[n];
            this.macAlgName = CipherSuites.macAlgName[n];
            this.macSize = CipherSuites.macSize[n];
            this.padSize = CipherSuites.padSize[n];
        }
    }
}

