/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ApplicationData;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.ProtocolUnitOutputStream;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLProtocolUnit;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLHandshakeException;

class SSLDataOutputStream
extends FilterOutputStream {
    private ProtocolUnitOutputStream os;
    private Object writeLock;
    private Object readLock;
    private HandShaker handShaker;

    SSLDataOutputStream(OutputStream outputStream, Object object, Object object2, SSLContext sSLContext) {
        super(outputStream);
        this.os = (ProtocolUnitOutputStream)outputStream;
        this.writeLock = object;
        this.readLock = object2;
        this.handShaker = sSLContext.getHandShaker();
    }

    public void close() throws IOException {
        super.close();
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)(n & 0xFF)});
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        Object object2;
        if (this.handShaker.handShakeNotYetBegun()) {
            object2 = this.writeLock;
            synchronized (object2) {
                if (this.handShaker instanceof ClientHandShaker) {
                    this.handShaker.startHandShake();
                }
                this.writeLock.notifyAll();
                object = this.readLock;
                synchronized (object) {
                    this.readLock.notifyAll();
                }
            }
        }
        object2 = this.writeLock;
        synchronized (object2) {
            try {
                while (!this.handShaker.handShakeCompleted()) {
                    this.writeLock.wait();
                }
                if (this.handShaker.badCompletion()) {
                    throw new SSLHandshakeException("Handshake failure");
                }
            }
            catch (InterruptedException interruptedException) {}
            object = new ApplicationData(byArray, n, n2);
            this.os.writeProtocolUnit((SSLProtocolUnit)object);
            if (Debug.debug >= 2) {
                Debug.debug("Sent something");
            }
        }
    }
}

