/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.V3Constants;
import java.io.IOException;
import java.security.MessageDigest;
import javax.net.ssl.SSLException;

public class SSLMac {
    private MessageDigest md;
    private MessageDigest md5;
    private MessageDigest sha;
    private int padSize;

    public SSLMac(String string, int n) {
        try {
            this.md = MessageDigest.getInstance(string);
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha = MessageDigest.getInstance("SHA");
            this.padSize = n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public byte[] computeHashes(MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, int n) throws IOException {
        if (n == 0) {
            return this.hash(messageDigest, messageDigest2, byArray, V3Constants.CLIENT, 0);
        }
        return this.hash(messageDigest, messageDigest2, byArray, V3Constants.SERVER, 0);
    }

    public byte[] computeKeyBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (Debug.debug >= 3) {
            Debug.debug("masterSecret: ", byArray);
        }
        byte[] byArray4 = new byte[112];
        int n = 0;
        while (n < 7) {
            System.arraycopy(this.doubleHash(byArray, V3Constants.SALTS[n], byArray3, byArray2), 0, byArray4, 16 * n, 16);
            ++n;
        }
        return byArray4;
    }

    public byte[] computeMasterSecret(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[48];
        int n = 0;
        while (n < 3) {
            System.arraycopy(this.doubleHash(byArray, V3Constants.SALTS[n], byArray2, byArray3), 0, byArray4, 16 * n, 16);
            ++n;
        }
        return byArray4;
    }

    private final byte[] doubleHash(byte[] byArray, String string, byte[] byArray2, byte[] byArray3) {
        this.md5.update(byArray);
        this.sha.update(string.getBytes());
        this.sha.update(byArray);
        this.sha.update(byArray2);
        this.sha.update(byArray3);
        this.md5.update(this.sha.digest());
        return this.md5.digest();
    }

    final byte[] hash(MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, byte[] byArray2, int n) throws SSLException {
        try {
            this.sha = (MessageDigest)messageDigest.clone();
            if (byArray2 != null) {
                this.sha.update(byArray2);
            }
            this.sha.update(byArray);
            this.sha.update(V3Constants.PAD1, 0, 40);
            byte[] byArray3 = this.sha.digest();
            this.sha.update(byArray);
            this.sha.update(V3Constants.PAD2, 0, 40);
            byte[] byArray4 = this.sha.digest(byArray3);
            if (n == 1) {
                return byArray4;
            }
            this.md5 = (MessageDigest)messageDigest2.clone();
            if (byArray2 != null) {
                this.md5.update(byArray2);
            }
            this.md5.update(byArray);
            this.md5.update(V3Constants.PAD1);
            byArray3 = this.md5.digest();
            this.md5.update(byArray);
            this.md5.update(V3Constants.PAD2);
            this.md5.update(byArray3);
            byte[] byArray5 = this.md5.digest();
            byte[] byArray6 = new byte[36];
            System.arraycopy(byArray5, 0, byArray6, 0, 16);
            System.arraycopy(byArray4, 0, byArray6, 16, 20);
            return byArray6;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new SSLException(cloneNotSupportedException.getMessage());
        }
    }

    public byte[] macMessage(byte[] byArray, byte[] byArray2, byte by, byte[] byArray3, byte[] byArray4) {
        this.md.update(byArray);
        this.md.update(V3Constants.PAD1, 0, this.padSize);
        this.md.update(byArray2);
        this.md.update(by);
        byte[] byArray5 = new byte[]{(byte)(byArray3.length >> 8 & 0xFF), (byte)(byArray3.length & 0xFF)};
        this.md.update(byArray5);
        this.md.update(byArray3);
        byte[] byArray6 = this.md.digest();
        this.md.update(byArray);
        this.md.update(V3Constants.PAD2, 0, this.padSize);
        this.md.update(byArray6);
        return this.md.digest();
    }
}

