/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.BaseSSLServerSocketFactory;
import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.PrivateKey;
import java.util.Vector;

final class SSLServerSocket
extends javax.net.ssl.SSLServerSocket {
    private BaseSSLServerSocketFactory sockFact = null;
    private String[] enabledCipherSuites;
    private PrivateKey privKey;
    private Vector serverCerts;
    private boolean clientAuthRequired;

    protected SSLServerSocket(BaseSSLServerSocketFactory baseSSLServerSocketFactory, int n, int n2, InetAddress inetAddress, PrivateKey privateKey, Vector vector, boolean bl, String[] stringArray) throws IOException {
        super(n, n2, inetAddress);
        this.init(baseSSLServerSocketFactory, privateKey, vector, bl, stringArray);
    }

    protected SSLServerSocket(BaseSSLServerSocketFactory baseSSLServerSocketFactory, int n, int n2, PrivateKey privateKey, Vector vector, boolean bl, String[] stringArray) throws IOException {
        super(n, n2);
        this.init(baseSSLServerSocketFactory, privateKey, vector, bl, stringArray);
    }

    protected SSLServerSocket(BaseSSLServerSocketFactory baseSSLServerSocketFactory, int n, PrivateKey privateKey, Vector vector, boolean bl, String[] stringArray) throws IOException {
        super(n);
        this.init(baseSSLServerSocketFactory, privateKey, vector, bl, stringArray);
    }

    public Socket accept() throws IOException {
        SSLSocket sSLSocket = new SSLSocket();
        this.implAccept(sSLSocket);
        if (Debug.debug >= 1) {
            Debug.debug("Client Auth required: " + this.clientAuthRequired);
        }
        sSLSocket.initialize(this.sockFact.getRandom(), this.privKey, this.serverCerts, this.sockFact.getTrustedCertificates(), this.enabledCipherSuites, this.clientAuthRequired, this.sockFact.getSessionCache());
        return sSLSocket;
    }

    public boolean getEnableSessionCreation() {
        return false;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public boolean getNeedClientAuth() {
        return this.clientAuthRequired;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    public boolean getUseClientMode() {
        return false;
    }

    private void init(BaseSSLServerSocketFactory baseSSLServerSocketFactory, PrivateKey privateKey, Vector vector, boolean bl, String[] stringArray) {
        this.sockFact = baseSSLServerSocketFactory;
        this.privKey = privateKey;
        this.serverCerts = vector;
        this.enabledCipherSuites = stringArray;
        this.clientAuthRequired = bl;
    }

    public void setEnableSessionCreation(boolean bl) {
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
    }

    public void setNeedClientAuth(boolean bl) {
        this.clientAuthRequired = bl;
    }

    public void setUseClientMode(boolean bl) {
    }
}

