/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.SessionCache;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionContext;

final class SSLSession
implements javax.net.ssl.SSLSession {
    private SessionCache cache = null;
    private byte[] id = null;
    private byte[] masterSecret = null;
    private String suite = null;
    private long creationTime = 0L;
    private long lastAccessTime = 0L;
    private X509Certificate[] peerCertChain = null;
    private String peerHost = null;
    private boolean isValid = true;

    SSLSession(SSLSocket sSLSocket, byte[] byArray, byte[] byArray2, String string, X509Certificate[] x509CertificateArray) {
        this.cache = sSLSocket.getSessionCache();
        this.id = byArray;
        this.masterSecret = byArray2;
        this.suite = string;
        this.lastAccessTime = this.creationTime = System.currentTimeMillis();
        this.peerCertChain = x509CertificateArray;
        this.peerHost = sSLSocket.getInetAddress().getHostName();
        sSLSocket.setSession(this);
    }

    void addToCache() {
        this.cache.addSession(this);
    }

    public String getCipherSuite() {
        return this.suite;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public byte[] getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessTime;
    }

    byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.peerCertChain == null) {
            throw new SSLPeerUnverifiedException("No certs for peer");
        }
        return this.peerCertChain;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public SSLSessionContext getSessionContext() {
        return this.cache;
    }

    public Object getValue(String string) {
        return null;
    }

    public String[] getValueNames() {
        return null;
    }

    public void invalidate() {
        this.isValid = false;
    }

    boolean isValid() {
        return this.isValid;
    }

    public void putValue(String string, Object object) {
    }

    public void removeValue(String string) {
    }

    private void toHex(StringBuffer stringBuffer, byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Integer.toHexString(0xFF & byArray[n]));
            ++n;
        }
        stringBuffer.append("\n");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SSL Session\n");
        stringBuffer.append("  id: ");
        this.toHex(stringBuffer, this.id);
        stringBuffer.append("  cipher suite:  ").append(this.suite).append("\n");
        stringBuffer.append("  peer host:     ").append(this.peerHost).append("\n");
        stringBuffer.append("  created:       ");
        stringBuffer.append(new Date(this.creationTime).toString()).append("\n");
        stringBuffer.append("  last accessed: ");
        stringBuffer.append(new Date(this.lastAccessTime).toString()).append("\n");
        return stringBuffer.toString();
    }

    void updateAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }
}

