/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.SSLContext;
import com.dstc.security.ssl.SSLDataInputStream;
import com.dstc.security.ssl.SSLDataOutputStream;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.SessionCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;

final class SSLSocket
extends javax.net.ssl.SSLSocket {
    private SSLContext ctx = null;
    private SSLSession session = null;
    private HandShaker handShaker = null;
    private String[] enabledCipherSuites = null;
    private boolean clientAuthRequired = false;
    private boolean sessionCreationEnabled = true;
    private SessionCache sessionCache = null;
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private SSLDataInputStream in = null;
    private SSLDataOutputStream out = null;

    protected SSLSocket() {
    }

    protected SSLSocket(String string, int n, InetAddress inetAddress, int n2, PrivateKey privateKey, Vector vector, String[] stringArray, Vector vector2, SessionCache sessionCache, SecureRandom secureRandom) throws UnknownHostException, IOException {
        super(string, n, inetAddress, n2);
        this.init(secureRandom, privateKey, vector, vector2, sessionCache);
        this.setEnabledCipherSuites(stringArray);
    }

    protected SSLSocket(String string, int n, PrivateKey privateKey, Vector vector, String[] stringArray, Vector vector2, SessionCache sessionCache, SecureRandom secureRandom) throws UnknownHostException, IOException {
        super(string, n);
        this.init(secureRandom, privateKey, vector, vector2, sessionCache);
        this.setEnabledCipherSuites(stringArray);
    }

    protected SSLSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, PrivateKey privateKey, Vector vector, String[] stringArray, Vector vector2, SessionCache sessionCache, SecureRandom secureRandom) throws UnknownHostException, IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.init(secureRandom, privateKey, vector, vector2, sessionCache);
        this.setEnabledCipherSuites(stringArray);
    }

    protected SSLSocket(InetAddress inetAddress, int n, PrivateKey privateKey, Vector vector, String[] stringArray, Vector vector2, SessionCache sessionCache, SecureRandom secureRandom) throws UnknownHostException, IOException {
        super(inetAddress, n);
        this.init(secureRandom, privateKey, vector, vector2, sessionCache);
        this.setEnabledCipherSuites(stringArray);
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.handShaker.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void close() throws IOException {
        try {
            Object object = this.readLock;
            synchronized (object) {
                while (!this.handShaker.handShakeCompleted()) {
                    this.readLock.notifyAll();
                    this.readLock.wait();
                }
                this.out.flush();
                this.handShaker.cleanup();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {}
        super.close();
    }

    SSLContext getContext() {
        return this.ctx;
    }

    public boolean getEnableSessionCreation() {
        return this.sessionCreationEnabled;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public boolean getNeedClientAuth() {
        return this.clientAuthRequired;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    Object getReadLock() {
        return this.readLock;
    }

    public SSLSession getSession() {
        return this.session;
    }

    SessionCache getSessionCache() {
        return this.sessionCache;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuites.suiteName;
    }

    public boolean getUseClientMode() {
        return false;
    }

    Object getWriteLock() {
        return this.writeLock;
    }

    private void init(SecureRandom secureRandom, PrivateKey privateKey, Vector vector, Vector vector2, SessionCache sessionCache) throws UnknownHostException, IOException {
        this.ctx = new SSLContext(super.getInputStream(), super.getOutputStream());
        this.sessionCache = sessionCache;
        this.handShaker = new ClientHandShaker(this, secureRandom, privateKey, vector, vector2);
        this.ctx.setHandShaker(this.handShaker);
        this.in = new SSLDataInputStream(this.ctx.getInputStream(), this.readLock, this.handShaker);
        this.out = new SSLDataOutputStream(this.ctx.getOutputStream(), this.writeLock, this.readLock, this.ctx);
    }

    void initialize(SecureRandom secureRandom, PrivateKey privateKey, Vector vector, Vector vector2, String[] stringArray, boolean bl, SessionCache sessionCache) throws UnknownHostException, IOException {
        this.ctx = new SSLContext(super.getInputStream(), super.getOutputStream());
        this.sessionCache = sessionCache;
        this.handShaker = new ServerHandShaker(this, secureRandom, privateKey, vector, vector2);
        this.setEnabledCipherSuites(stringArray);
        this.setNeedClientAuth(bl);
        this.ctx.setHandShaker(this.handShaker);
        this.in = new SSLDataInputStream(this.ctx.getInputStream(), this.readLock, this.handShaker);
        this.out = new SSLDataOutputStream(this.ctx.getOutputStream(), this.writeLock, this.readLock, this.ctx);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
    }

    public void setEnableSessionCreation(boolean bl) {
        this.sessionCreationEnabled = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.enabledCipherSuites = stringArray;
        this.handShaker.setEnabledCipherSuites(stringArray);
    }

    public void setNeedClientAuth(boolean bl) {
        this.clientAuthRequired = bl;
        ((ServerHandShaker)this.handShaker).setClientAuthRequired(bl);
    }

    void setSession(SSLSession sSLSession) {
        this.session = sSLSession;
    }

    public void setUseClientMode(boolean bl) {
    }

    public void startHandshake() throws IOException {
        this.handShaker.startHandShake();
    }
}

