/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.pkcs8.PKCS8EncryptedPrivateKey;
import com.dstc.security.ssl.BaseSSLSocketFactory;
import com.dstc.security.ssl.Debug;
import com.dstc.security.util.Config;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.net.SocketFactory;
import javax.net.ssl.SSLKeyException;

public final class SSLSocketFactory
extends BaseSSLSocketFactory {
    private CertificateFactory certFact;
    private String keyDir = null;
    private static final String SSL_CONF = "jcsi.ssl.conf";
    private static final String SSL_PROPERTIES = "ssl.properties";

    static {
        block2: {
            if (BaseSSLSocketFactory.instance != null) break block2;
            try {
                BaseSSLSocketFactory.instance = new SSLSocketFactory();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected SSLSocketFactory() throws SSLKeyException {
        this.initializeKeys();
    }

    public static SocketFactory getDefault() {
        return BaseSSLSocketFactory.instance;
    }

    protected void initializeKeys() throws SSLKeyException {
        try {
            String[] stringArray;
            this.certFact = CertificateFactory.getInstance("X509");
            Properties properties = Config.getProperties(SSL_CONF, SSL_PROPERTIES);
            this.keyDir = (String)((Hashtable)properties).get("jcsi.ssl.key.dir");
            String string = (String)((Hashtable)properties).get("jcsi.ssl.debugLevel");
            Debug.debug = Integer.parseInt(string);
            Vector<String[]> vector = new Vector<String[]>();
            int n = 1;
            while ((stringArray = (String[])((Hashtable)properties).get("jcsi.ssl.enabledCipherSuite." + n)) != null) {
                vector.addElement(stringArray);
                ++n;
            }
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
            this.setDefaultCipherSuites(stringArray);
            this.loadKeyAndCerts(properties);
            this.loadTrustedCerts(properties);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadKeyAndCerts(Properties properties) throws IOException {
        try {
            Object object;
            Object object2;
            String string = (String)((Hashtable)properties).get("jcsi.ssl.clientPrivKey");
            if (string == null) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.keyDir) + File.separator + string);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            String string2 = (String)((Hashtable)properties).get("jcsi.ssl.clientPrivKey.password");
            if (string2 == null) {
                System.out.print("Enter password to unlock private key: ");
                object2 = new InputStreamReader(System.in);
                object = new BufferedReader((Reader)object2);
                string2 = ((BufferedReader)object).readLine();
            }
            object2 = new PKCS8EncryptedPrivateKey(byArray);
            ((PKCS8EncryptedPrivateKey)object2).decrypt(string2);
            this.setClientPrivateKey(((PKCS8EncryptedPrivateKey)object2).getPrivateKey());
            object = (String)((Hashtable)properties).get("jcsi.ssl.clientCerts");
            if (object == null) {
                return;
            }
            fileInputStream = new FileInputStream(String.valueOf(this.keyDir) + File.separator + (String)object);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray2 = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray2);
            fileInputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            while (byteArrayInputStream.available() != 0) {
                vector.addElement((X509Certificate)this.certFact.generateCertificate(byteArrayInputStream));
            }
            this.setClientCertificates(vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void loadTrustedCerts(Properties properties) throws SSLKeyException {
        try {
            String string = (String)((Hashtable)properties).get("jcsi.ssl.trustedCerts");
            if (string == null) {
                return;
            }
            File file = new File(String.valueOf(this.keyDir) + File.separator + string);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            byte[] byArray = new byte[dataInputStream.available()];
            dataInputStream.readFully(byArray);
            fileInputStream.close();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            while (byteArrayInputStream.available() > 0) {
                X509Certificate x509Certificate = (X509Certificate)this.certFact.generateCertificate(byteArrayInputStream);
                vector.add(x509Certificate);
            }
            this.setTrustedCertificates(vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

