/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.Alert;
import com.dstc.security.ssl.Certificate;
import com.dstc.security.ssl.CertificateRequest;
import com.dstc.security.ssl.ChangeCipherSpec;
import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.DHServerKeyExchange;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.Finished;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.HandShaker;
import com.dstc.security.ssl.HelloRequest;
import com.dstc.security.ssl.RSAServerKeyExchange;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.SSLSession;
import com.dstc.security.ssl.SSLSocket;
import com.dstc.security.ssl.ServerHello;
import com.dstc.security.ssl.ServerHelloDone;
import com.dstc.security.ssl.V2ClientHello;
import com.dstc.security.ssl.XDROutputStream;
import com.dstc.security.x509.X500Name;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;

final class ServerHandShaker
extends HandShaker {
    private Vector serverCerts;
    private byte expectedHandShake;
    private byte expectedContentType;

    protected ServerHandShaker(SSLSocket sSLSocket, SecureRandom secureRandom, PrivateKey privateKey, Vector vector, Vector vector2) throws SSLException {
        super(sSLSocket, secureRandom, vector2);
        if (privateKey.getAlgorithm().equals("RSA") || privateKey.getAlgorithm().equals("DSA")) {
            this.serverSigningKey = privateKey;
        }
        if (!privateKey.getAlgorithm().equals("DSA")) {
            this.serverKeyXKey = privateKey;
        }
        this.serverCerts = vector;
        this.currentId = new byte[32];
    }

    protected void changeReadCipher() throws SSLException {
        this.ctx.setKeyData(0, 0, this.keyBlock, this.serverHelloRandom, this.clientHelloRandom);
    }

    protected void changeWriteCipher() throws SSLException {
        this.ctx.setKeyData(1, 1, this.keyBlock, this.serverHelloRandom, this.clientHelloRandom);
    }

    protected final byte[] generateServerSignature(byte[] byArray) throws IOException {
        try {
            String string = this.serverSigningKey.getAlgorithm();
            Signature signature = Signature.getInstance("Raw" + string);
            signature.initSign((PrivateKey)this.serverSigningKey, this.rand);
            signature.update(this.toBeSignedSKX(byArray, string));
            return signature.sign();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected DHPublicKey generateTempDHPubKey(int n) throws IOException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
            keyPairGenerator.initialize(n, this.rand);
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            this.serverKeyXKey = keyPair.getPrivate();
            this.pubKeyBitLength = ((DHPublicKey)keyPair.getPublic()).getY().bitLength();
            return (DHPublicKey)keyPair.getPublic();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected RSAPublicKey generateTempRSAPubKey() throws IOException {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(512, this.rand);
            KeyPair keyPair = ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
            this.serverKeyXKey = keyPair.getPrivate();
            return (RSAPublicKey)keyPair.getPublic();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected byte[] getPendingCipherSuite() {
        if (Debug.debug >= 1) {
            Debug.debug("\nChosen Cipher Suite");
            Debug.debug(String.valueOf(CipherSuites.getSuiteName(this.pendingCipherSuite)) + "\n");
        }
        return this.pendingCipherSuite;
    }

    protected final byte[] getServerHelloRandom() {
        byte[] byArray = new byte[32];
        this.rand.nextBytes(byArray);
        this.serverHelloRandom = (byte[])byArray.clone();
        return byArray;
    }

    protected byte[] getSessionID() {
        return this.currentId;
    }

    protected void nextMessage(SSLProtocolUnit sSLProtocolUnit) throws IOException {
        block17: {
            block18: {
                block16: {
                    if (sSLProtocolUnit.getContentType() != 21 && sSLProtocolUnit.getContentType() != this.expectedContentType) {
                        this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 10));
                        this.handShakeState = 3;
                        throw new SSLHandshakeException("Messages out of order");
                    }
                    if (!(sSLProtocolUnit instanceof V2ClientHello)) break block16;
                    this.respondToClientHello();
                    this.expectedHandShake = this.clientAuthRequired ? (byte)11 : (byte)-1;
                    break block17;
                }
                if (sSLProtocolUnit.getContentType() != 22) break block18;
                byte by = ((HandShake)sSLProtocolUnit).getMessageType();
                if (this.expectedHandShake != -1 && by != this.expectedHandShake) {
                    this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 10));
                    this.handShakeState = 3;
                    throw new SSLHandshakeException("Messages out of order");
                }
                switch (by) {
                    case 1: {
                        this.respondToClientHello();
                        this.expectedHandShake = this.clientAuthRequired && !this.sessionReuse ? (byte)11 : (byte)-1;
                        break block17;
                    }
                    case 16: {
                        if (this.clientAuthRequired && this.clientSigningKey != null) {
                            this.expectedHandShake = (byte)15;
                        } else {
                            this.expectedContentType = (byte)20;
                            this.expectedHandShake = (byte)-1;
                        }
                        break block17;
                    }
                    case 11: {
                        this.expectedHandShake = (byte)16;
                        break block17;
                    }
                    case 15: {
                        this.expectedHandShake = (byte)20;
                        this.expectedContentType = (byte)20;
                        break block17;
                    }
                    case 20: {
                        if (!this.sessionReuse) {
                            this.ctx.getOutputStream().writeProtocolUnit(new ChangeCipherSpec());
                            this.changeWriteCipher();
                            Finished finished = new Finished(this);
                            this.ctx.getOutputStream().writeProtocolUnit(finished);
                        }
                        this.handShakeState = 2;
                        this.signalHandshakeCompleted();
                        this.reset();
                        break block17;
                    }
                    default: {
                        this.handShakeState = 3;
                        this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 10));
                        throw new SSLProtocolException("Bad message");
                    }
                }
            }
            if (sSLProtocolUnit.getContentType() == 20) {
                if (!this.sessionReuse) {
                    this.computeKeyBlock();
                }
                this.changeReadCipher();
                this.expectedContentType = (byte)22;
            } else if (sSLProtocolUnit.getContentType() == 21) {
                this.handShakeState = 3;
                throw new SSLHandshakeException("hand shake failure");
            }
        }
    }

    protected final byte[] processAcceptableCAs(Vector vector) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
            int n = 0;
            while (n < vector.size()) {
                X500Name x500Name = (X500Name)vector.elementAt(n);
                if (Debug.debug >= 1) {
                    x500Name.info();
                }
                xDROutputStream.writeVector(2, x500Name.encode());
                ++n;
            }
            xDROutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }

    protected void reset() throws SSLException {
        super.reset();
        if (this.serverSigningKey != null && !this.serverSigningKey.getAlgorithm().equals("DSA")) {
            this.serverKeyXKey = this.serverSigningKey;
        }
        this.expectedHandShake = 1;
        this.expectedContentType = (byte)22;
    }

    private void respondToClientHello() throws IOException {
        Object object;
        this.handShakeState = 1;
        ServerHello serverHello = new ServerHello(this);
        this.ctx.getOutputStream().writeProtocolUnit(serverHello);
        if (this.sessionReuse) {
            this.ctx.getOutputStream().writeProtocolUnit(new ChangeCipherSpec());
            this.computeKeyBlock();
            this.changeWriteCipher();
            Finished finished = new Finished(this);
            this.ctx.getOutputStream().writeProtocolUnit(finished);
            this.expectedContentType = (byte)20;
            return;
        }
        Certificate certificate = new Certificate((HandShaker)this, this.serverCerts);
        this.ctx.getOutputStream().writeProtocolUnit(certificate);
        if (this.isDiffieHellmanEphKeyX()) {
            int n = 1024;
            if (this.isExportable()) {
                n = 512;
            }
            object = new DHServerKeyExchange(this, n);
            this.ctx.getOutputStream().writeProtocolUnit((SSLProtocolUnit)object);
        } else if (this.isExportable()) {
            RSAServerKeyExchange rSAServerKeyExchange = new RSAServerKeyExchange(this, 512);
            this.ctx.getOutputStream().writeProtocolUnit(rSAServerKeyExchange);
        }
        if (this.clientAuthRequired) {
            if (this.trustEngine.getTrustedCerts() == null) {
                this.handShakeState = 3;
                throw new SSLKeyException("No trusted CA certs set");
            }
            Vector<X500Name> vector = new Vector<X500Name>();
            object = ((AbstractList)this.trustEngine.getTrustedCerts()).iterator();
            while (object.hasNext()) {
                vector.addElement(new X500Name(((X509Certificate)object.next()).getSubjectDN().getName()));
            }
            CertificateRequest certificateRequest = new CertificateRequest(this, new byte[]{1, 2}, vector);
            this.ctx.getOutputStream().writeProtocolUnit(certificateRequest);
        }
        ServerHelloDone serverHelloDone = new ServerHelloDone(this);
        this.ctx.getOutputStream().writeProtocolUnit(serverHelloDone);
    }

    protected void setCipherSuite(Vector vector) throws IOException {
        if (Debug.debug >= 1) {
            Debug.debug("\nOffered Cipher Suite");
            int n = 0;
            while (n < vector.size()) {
                Debug.debug(CipherSuites.getSuiteName((byte[])vector.elementAt(n)));
                ++n;
            }
            Debug.debug("");
        }
        byte[][] byArray = new byte[this.enabledCipherSuites.size()][];
        this.enabledCipherSuites.toArray((T[])byArray);
        String string = ((X509Certificate)this.serverCerts.elementAt(0)).getPublicKey().getAlgorithm();
        if (string.equals("Diffie-Hellman")) {
            string = "DH";
        }
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n = 0;
        while (n < vector.size()) {
            byte[] byArray2 = (byte[])vector.elementAt(n);
            int n2 = 0;
            while (n2 < byArray.length) {
                if (Arrays.equals(byArray2, byArray[n2])) {
                    vector2.addElement(byArray2);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < vector2.size()) {
            byte[] byArray3 = (byte[])vector2.elementAt(n3);
            String string2 = CipherSuites.getKeyXAlgName(byArray3);
            if (string2.indexOf("RSA") != -1) {
                this.setPendingCipherSuite(byArray3);
                break;
            }
            if (string2.indexOf("DHE_RSA") != -1 && string.equals("RSA")) {
                this.setPendingCipherSuite(byArray3);
                break;
            }
            if (string2.indexOf("DHE_DSS") != -1 && string.equals("DSA")) {
                this.setPendingCipherSuite(byArray3);
                break;
            }
            if ((string2.equals("DH") || string2.equals("DH_EXP")) && string.equals("DH")) {
                this.setPendingCipherSuite(byArray3);
                break;
            }
            ++n3;
        }
        if (this.pendingCipherSuite == null) {
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            this.handShakeState = 3;
            throw new SSLHandshakeException("Cannot support offered cipher suites");
        }
    }

    protected void setClientAuthRequired(boolean bl) {
        this.clientAuthRequired = bl;
    }

    protected void setClientHelloRandom(byte[] byArray) {
        this.clientHelloRandom = byArray;
    }

    protected void setMasterSecret(byte[] byArray) throws IOException {
        try {
            if (Debug.debug >= 3) {
                Debug.debug("exchangeKeys: ", byArray);
            }
            byte[] byArray2 = null;
            if (this.serverKeyXKey.getAlgorithm().equals("DH") || this.serverKeyXKey.getAlgorithm().equals("Diffie-Hellman")) {
                KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
                keyAgreement.init(this.serverKeyXKey, this.rand);
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(new DHPublicKeySpec(new BigInteger(1, byArray), ((DHPrivateKey)this.serverKeyXKey).getParams().getP(), ((DHPrivateKey)this.serverKeyXKey).getParams().getG()));
                keyAgreement.doPhase(dHPublicKey, true);
                byArray2 = keyAgreement.generateSecret();
            } else {
                Cipher cipher = Cipher.getInstance("RSA");
                cipher.init(2, this.serverKeyXKey);
                byArray2 = cipher.doFinal(byArray);
            }
            if (Debug.debug >= 3) {
                Debug.debug("isDiffieHellmanKeyX(): " + this.isDiffieHellmanKeyX());
                Debug.debug("preMasterSecret: ", byArray2);
            }
            this.computeMasterSecret(byArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLHandshakeException(exception.getMessage());
        }
    }

    protected void setPubKeyBitLength(X509Certificate x509Certificate) throws IOException {
        try {
            if (x509Certificate.getPublicKey().getAlgorithm().equals("RSA")) {
                this.pubKeyBitLength = ((RSAPublicKey)x509Certificate.getPublicKey()).getModulus().bitLength();
            } else if (x509Certificate.getPublicKey().getAlgorithm().equals("DSA")) {
                this.pubKeyBitLength = ((DSAPublicKey)x509Certificate.getPublicKey()).getParams().getP().bitLength();
            } else {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(x509Certificate.getPublicKey().getEncoded());
                DHPublicKey dHPublicKey = (DHPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
                this.pubKeyBitLength = dHPublicKey.getParams().getP().bitLength();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLKeyException(exception.getMessage());
        }
    }

    protected void setSessionId(byte[] byArray) {
        SSLSession sSLSession = (SSLSession)this.socket.getSessionCache().getSession(byArray);
        if (sSLSession == null) {
            this.rand.nextBytes(this.currentId);
            long l = System.currentTimeMillis();
            this.currentId[0] = (byte)(l >> 24 & 0xFFL);
            this.currentId[1] = (byte)(l >> 16 & 0xFFL);
            this.currentId[2] = (byte)(l >> 8 & 0xFFL);
            this.currentId[3] = (byte)(l & 0xFFL);
        } else {
            this.currentId = byArray;
            this.sessionReuse = true;
            this.masterSecret = sSLSession.getMasterSecret();
        }
    }

    protected void startHandShake() throws IOException {
        this.reset();
        this.handShakeState = 1;
        HelloRequest helloRequest = new HelloRequest(this);
        this.ctx.getOutputStream().writeProtocolUnit(helloRequest);
    }

    protected final void verifyClientSignature(byte[] byArray) throws IOException {
        try {
            String string = this.clientSigningKey.getAlgorithm();
            Signature signature = Signature.getInstance("Raw" + string);
            signature.initVerify((PublicKey)this.clientSigningKey);
            signature.update(this.toBeSignedCV(string));
            if (!signature.verify(byArray)) {
                this.handShakeState = 3;
                this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
                throw new SSLHandshakeException("Bad signature");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handShakeState = 3;
            this.ctx.getOutputStream().writeProtocolUnit(new Alert(2, 40));
            throw new SSLException(exception.getMessage());
        }
    }
}

