/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;

final class ServerHello
extends HandShake {
    private byte[] version;
    private byte compression;
    private byte[] random;
    private byte[] sessionId;
    private byte[] cipherSuite;

    protected ServerHello(ClientHandShaker clientHandShaker, byte[] byArray) throws IOException, SSLHandshakeException {
        super(clientHandShaker, byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++ ServerHello");
        }
    }

    protected ServerHello(ServerHandShaker serverHandShaker) throws IOException {
        this.handShaker = serverHandShaker;
        this.msgType = (byte)2;
        this.version = serverHandShaker.getProtocolVersion();
        this.compression = serverHandShaker.getCompressionMethods()[0];
        this.random = serverHandShaker.getServerHelloRandom();
        this.sessionId = serverHandShaker.getSessionID();
        this.cipherSuite = serverHandShaker.getPendingCipherSuite();
        this.bodyLength = 34 + (1 + this.sessionId.length) + 2 + 1;
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException, SSLHandshakeException {
        this.version = xDRInputStream.readBytes(2);
        this.handShaker.setProtocolVersion(this.version);
        this.random = xDRInputStream.readBytes(32);
        this.handShaker.setServerHelloRandom(this.random);
        this.sessionId = xDRInputStream.readVector(1);
        this.handShaker.setSessionId(this.sessionId);
        this.cipherSuite = xDRInputStream.readBytes(2);
        if (Debug.debug >= 1) {
            Debug.debug("\nChosen Cipher Suite");
            Debug.debug(CipherSuites.getSuiteName(this.cipherSuite));
            Debug.debug("");
        }
        this.compression = xDRInputStream.readByte();
        ((ClientHandShaker)this.handShaker).setPendingCipherSuite(this.cipherSuite);
    }

    protected void writeBody(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.write(this.version);
        xDROutputStream.write(this.random);
        xDROutputStream.writeVector(1, this.sessionId);
        xDROutputStream.write(this.cipherSuite);
        xDROutputStream.writeByte(this.compression);
    }
}

