/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.ClientHandShaker;
import com.dstc.security.ssl.HandShake;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import com.dstc.security.ssl.XDROutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

abstract class ServerKeyExchange
extends HandShake {
    protected byte[] signature;
    protected byte[] params;
    protected int keyLength;

    protected ServerKeyExchange(ClientHandShaker clientHandShaker, byte[] byArray) throws IOException {
        super(clientHandShaker, byArray);
    }

    protected ServerKeyExchange(ServerHandShaker serverHandShaker, int n) throws IOException {
        this.handShaker = serverHandShaker;
        this.msgType = (byte)12;
        this.keyLength = n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
        this.generateParamsAndSig(xDROutputStream);
        xDROutputStream.flush();
        this.params = byteArrayOutputStream.toByteArray();
        this.signature = serverHandShaker.generateServerSignature(this.params);
        this.bodyLength = 2 + this.params.length + this.signature.length;
    }

    protected abstract void generateParamsAndSig(XDROutputStream var1) throws IOException;

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XDROutputStream xDROutputStream = new XDROutputStream(byteArrayOutputStream);
        this.verifyParamsSig(xDRInputStream, xDROutputStream);
        xDROutputStream.flush();
        this.params = byteArrayOutputStream.toByteArray();
        this.signature = xDRInputStream.readVector(2);
        ((ClientHandShaker)this.handShaker).verifyServerSignature(this.params, this.signature);
    }

    protected abstract void verifyParamsSig(XDRInputStream var1, XDROutputStream var2) throws IOException;

    protected void writeBody(XDROutputStream xDROutputStream) throws IOException {
        xDROutputStream.write(this.params);
        xDROutputStream.writeVector(2, this.signature);
    }
}

