/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.SSLSession;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLSessionContext;

final class SessionCache
implements SSLSessionContext {
    private Hashtable tab = new Hashtable();

    SessionCache() {
    }

    void addSession(SSLSession sSLSession) {
        this.tab.put(new SessionId(sSLSession.getId()), sSLSession);
    }

    void clear() {
        this.tab.clear();
    }

    SSLSession getFirstValidSession() {
        Iterator iterator = this.tab.keySet().iterator();
        while (iterator.hasNext()) {
            SSLSession sSLSession = (SSLSession)this.tab.get((SessionId)iterator.next());
            if (!sSLSession.isValid()) continue;
            return sSLSession;
        }
        return null;
    }

    public Enumeration getIds() {
        Vector<byte[]> vector = new Vector<byte[]>(this.tab.size());
        Iterator iterator = this.tab.keySet().iterator();
        while (iterator.hasNext()) {
            vector.addElement(((SessionId)iterator.next()).getId());
        }
        return vector.elements();
    }

    public javax.net.ssl.SSLSession getSession(byte[] byArray) {
        SSLSession sSLSession = (SSLSession)this.tab.get(new SessionId(byArray));
        if (sSLSession != null && sSLSession.isValid()) {
            return sSLSession;
        }
        return null;
    }

    final class SessionId {
        private byte[] id;

        SessionId(byte[] byArray) {
            this.id = byArray;
        }

        public boolean equals(Object object) {
            try {
                return Arrays.equals(this.id, ((SessionId)object).getId());
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        byte[] getId() {
            return this.id;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.id.length) {
                n |= this.id[n3] << 8 * n2;
                if (++n2 == 4) {
                    n2 = 0;
                }
                ++n3;
            }
            return n;
        }
    }
}

