/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.x509.Base64OutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;

public class TrustEngine {
    private static final boolean OFFER = false;
    protected Vector trustedCerts = null;

    public TrustEngine(Vector vector) {
        this.trustedCerts = vector;
    }

    public Vector getTrustedCerts() {
        return this.trustedCerts;
    }

    private void offer(X509Certificate x509Certificate) throws IOException, CertificateException {
        System.out.print("Your peer root cert is not yet trusted\n");
        System.out.print("Enter filename to save root cert: ");
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Base64OutputStream base64OutputStream = new Base64OutputStream(new FileOutputStream(bufferedReader.readLine()), "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
        base64OutputStream.write(x509Certificate.getEncoded());
        base64OutputStream.flush();
        base64OutputStream.close();
    }

    public void setTrustedCerts(Vector vector) {
        this.trustedCerts = vector;
    }

    public void verifyCertChain(X509Certificate[] x509CertificateArray) throws IOException, CertificateException {
        try {
            X509Certificate x509Certificate = x509CertificateArray[0];
            int n = 1;
            while (n < x509CertificateArray.length) {
                x509Certificate.checkValidity();
                X509Certificate x509Certificate2 = x509CertificateArray[n];
                x509Certificate.verify(x509Certificate2.getPublicKey());
                x509Certificate = x509Certificate2;
                ++n;
            }
            Principal principal = x509Certificate.getIssuerDN();
            Principal principal2 = x509Certificate.getSubjectDN();
            if (this.trustedCerts == null) {
                throw new SSLKeyException("No trusted CA certs set");
            }
            Iterator iterator = ((AbstractList)this.trustedCerts).iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate3 = (X509Certificate)iterator.next();
                if (principal.equals(x509Certificate3.getSubjectDN())) {
                    x509Certificate.verify(x509Certificate3.getPublicKey());
                    return;
                }
                if (!principal2.equals(x509Certificate3.getSubjectDN()) || !Arrays.equals(x509Certificate.getEncoded(), x509Certificate3.getEncoded())) continue;
                return;
            }
            throw new SSLHandshakeException("Cannot find trusted CA");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SSLHandshakeException(exception.getMessage());
        }
    }
}

