/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.CipherSuites;
import com.dstc.security.ssl.Debug;
import com.dstc.security.ssl.SSLProtocolUnit;
import com.dstc.security.ssl.ServerHandShaker;
import com.dstc.security.ssl.XDRInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;

final class V2ClientHello
implements SSLProtocolUnit {
    private byte[] random;
    private byte[] version;
    private byte[] sessionId;
    private Vector cipherSuites;
    private ServerHandShaker handShaker;
    private byte msgType;
    private byte[] contents;

    V2ClientHello(ServerHandShaker serverHandShaker, byte[] byArray) throws IOException {
        this.handShaker = serverHandShaker;
        this.contents = byArray;
        XDRInputStream xDRInputStream = new XDRInputStream(new BufferedInputStream(new ByteArrayInputStream(byArray)));
        this.readBody(xDRInputStream);
        serverHandShaker.updateHashes(byArray);
        if (Debug.debug >= 1) {
            Debug.debug("++V2ClientHello");
        }
    }

    public byte[] getBytes() throws IOException {
        return this.contents;
    }

    public byte getContentType() {
        return 22;
    }

    public int getLength() {
        return this.contents.length;
    }

    protected void readBody(XDRInputStream xDRInputStream) throws IOException {
        this.msgType = xDRInputStream.readByte();
        this.version = xDRInputStream.readBytes(2);
        int n = xDRInputStream.readShort() / 3;
        short s = xDRInputStream.readShort();
        short s2 = xDRInputStream.readShort();
        this.cipherSuites = new Vector();
        int n2 = 0;
        while (n2 < n) {
            this.cipherSuites.addElement(xDRInputStream.readBytes(3));
            ++n2;
        }
        this.sessionId = xDRInputStream.readBytes(s);
        this.handShaker.setSessionId(this.sessionId);
        this.random = xDRInputStream.readBytes(s2);
        byte[] byArray = new byte[32];
        System.arraycopy(this.random, 0, byArray, 32 - this.random.length, this.random.length);
        this.handShaker.setClientHelloRandom(byArray);
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.addElement(CipherSuites.suiteType[0]);
        this.handShaker.setCipherSuite(vector);
    }
}

