/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class XDRInputStream
extends DataInputStream {
    XDRInputStream(InputStream inputStream) {
        super(inputStream);
    }

    int read3Bytes() throws IOException {
        byte[] byArray = new byte[3];
        if (this.read(byArray) == -1) {
            return -1;
        }
        return (byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[2] & 0xFF;
    }

    byte[] readBytes(int n) throws IOException {
        if (n == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        return byArray;
    }

    byte[] readVector(int n) throws IOException {
        byte[] byArray;
        switch (n) {
            case 1: {
                byArray = new byte[this.readByte()];
                break;
            }
            case 2: {
                byArray = new byte[this.readShort()];
                break;
            }
            case 3: {
                byArray = new byte[this.read3Bytes()];
                break;
            }
            default: {
                byArray = new byte[this.readInt()];
            }
        }
        if (byArray.length == 0) {
            return byArray;
        }
        this.readFully(byArray);
        return byArray;
    }
}

