/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Null;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.OID;
import java.io.IOException;
import java.security.AlgorithmParameters;

public class AlgorithmId
extends Sequence {
    private String oid;
    private AlgorithmParameters params;

    public AlgorithmId(String string) {
        this.oid = string;
        this.addComponent(new Oid(string));
        this.params = null;
        this.addComponent(new Null());
    }

    public AlgorithmId(String string, AlgorithmParameters algorithmParameters) throws Asn1Exception {
        this.oid = string;
        this.addComponent(new Oid(string));
        this.params = algorithmParameters;
        try {
            if (algorithmParameters == null) {
                this.addComponent(new Null());
            } else {
                this.addComponent(Asn1.decode(algorithmParameters.getEncoded()));
            }
        }
        catch (IOException iOException) {
            throw new Asn1Exception(iOException.toString());
        }
    }

    public AlgorithmId(String string, boolean bl) {
        this.oid = string;
        this.addComponent(new Oid(string));
    }

    public AlgorithmId(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.oid = ((Oid)this.components.elementAt(0)).getOid();
        if (this.components.size() <= 1) {
            return;
        }
        try {
            Null nullVal = (Null)this.components.elementAt(1);
            this.params = null;
            return;
        }
        catch (ClassCastException classCastException) {
            try {
                String string = OID.getAlgName(this.oid);
                this.params = AlgorithmParameters.getInstance(string);
                this.params.init(((Asn1)this.components.elementAt(1)).encode());
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
                exception.printStackTrace();
            }
            return;
        }
    }

    public String getOid() {
        return this.oid;
    }

    public AlgorithmParameters getParams() {
        return this.params;
    }
}

