/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BMPString;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.PrintableString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.T61String;
import com.dstc.security.provider.OID;

public class AttributeTypeAndValue
extends Sequence {
    private String type;
    private String value;

    public AttributeTypeAndValue(String string, String string2) {
        this.type = string.indexOf(46) != -1 ? string : OID.getAlgOid(string);
        this.addComponent(new Oid(this.type));
        this.value = string2;
        if (!this.type.equals("1.2.840.113549.1.9.1")) {
            this.addComponent(new PrintableString(string2));
        } else {
            this.addComponent(new IA5String(string2));
        }
    }

    public AttributeTypeAndValue(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.type = ((Oid)this.components.elementAt(0)).getOid();
        try {
            this.value = ((PrintableString)this.components.elementAt(1)).getName();
            return;
        }
        catch (ClassCastException classCastException) {
            try {
                this.value = ((T61String)this.components.elementAt(1)).getName();
                return;
            }
            catch (ClassCastException classCastException2) {
                try {
                    this.value = ((BMPString)this.components.elementAt(1)).getName();
                    return;
                }
                catch (ClassCastException classCastException3) {
                    this.value = ((IA5String)this.components.elementAt(1)).getName();
                    return;
                }
            }
        }
    }

    public String getName() {
        return String.valueOf(OID.getAlgName(this.type)) + "=" + this.value;
    }

    public String getRawName() {
        return String.valueOf(this.type) + "=" + this.value;
    }

    public String getType() {
        return OID.getAlgName(this.type);
    }

    public String getValue() {
        return this.value;
    }
}

