/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends FilterInputStream {
    private byte[] headerBytes = null;
    private byte[] footerBytes = null;

    public Base64InputStream(InputStream inputStream, String string, String string2) {
        super(inputStream);
        if (string == null) {
            return;
        }
        try {
            this.headerBytes = string.getBytes();
            while (inputStream.available() > 0) {
                if (inputStream.read() == this.headerBytes[0]) break;
            }
            byte[] byArray = new byte[this.headerBytes.length];
            inputStream.read(byArray);
            this.footerBytes = string2.getBytes();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public int available() throws IOException {
        return this.in.available() * 4 / 5;
    }

    private static final byte[] fromBase64(byte[] byArray) {
        byte[] byArray2 = new byte[3];
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            byte by = byArray[n];
            if (by > 96) {
                nArray[n] = by - 71;
            } else if (by > 64) {
                nArray[n] = by - 65;
            } else if (by > 47) {
                nArray[n] = by + 4;
            } else if (by == 43) {
                nArray[n] = 62;
            } else if (by == 47) {
                nArray[n] = 63;
            }
            ++n;
        }
        byArray2[0] = (byte)((nArray[0] & 0xFF) << 2 | (nArray[1] & 0xFF) >> 4);
        byArray2[1] = (byte)((nArray[1] & 0xFF) << 4 | (nArray[2] & 0xFF) >> 2);
        byArray2[2] = (byte)((nArray[2] & 0xFF) << 6 | nArray[3] & 0xFF);
        return byArray2;
    }

    public int read(byte[] byArray) throws IOException {
        int n;
        byte[] byArray2 = new byte[4];
        for (n = 0; n < byArray.length; n += 3) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = this.in.read();
                if (n3 == -1) {
                    if (n2 > 0) {
                        throw new IOException("Unexpected end of data encountered");
                    }
                    return n;
                }
                if (this.footerBytes != null && n3 == this.footerBytes[0]) {
                    this.in.skip(this.footerBytes.length);
                    return n;
                }
                if (n3 < 43 || n3 > 122) continue;
                byArray2[n2] = (byte)n3;
                ++n2;
            }
            System.arraycopy(Base64InputStream.fromBase64(byArray2), 0, byArray, n, 3);
        }
        return n;
    }
}

