/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private byte[] footer;
    private static final int WIDTH = 18;
    private int count = 0;
    private byte[] buffer = new byte[3];
    private int bufferLen;
    protected static final char[] table = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public Base64OutputStream(OutputStream outputStream, String string, String string2) {
        super(outputStream);
        try {
            if (string != null) {
                this.out.write(string.getBytes());
                this.out.write(10);
            }
            if (string2 != null) {
                this.footer = string2.getBytes();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void flush() throws IOException {
        this.writeLastBlock();
        this.out.write(10);
        if (this.footer != null) {
            this.out.write(this.footer);
            this.out.write(10);
        }
        super.flush();
    }

    public void write(byte[] byArray) throws IOException {
        int n = 0;
        if (this.bufferLen != 0) {
            int n2 = this.buffer.length - this.bufferLen;
            System.arraycopy(byArray, n, this.buffer, this.bufferLen, n2);
            this.writeBase64(this.buffer, 0);
            this.bufferLen = 0;
            n += n2;
        }
        do {
            this.writeBase64(byArray, n);
            n += 3;
            ++this.count;
            if (this.count != 18) continue;
            this.out.write(10);
            this.count = 0;
        } while (n < byArray.length - 3);
        this.bufferLen = byArray.length - n;
        System.arraycopy(byArray, n, this.buffer, 0, this.bufferLen);
    }

    private void writeBase64(byte[] byArray, int n) throws IOException {
        this.out.write(table[(byArray[n] & 0xFC) >> 2]);
        this.out.write(table[(byArray[n] & 3) << 4 | (byArray[n + 1] & 0xF0) >> 4]);
        this.out.write(table[(byArray[n + 1] & 0xF) << 2 | (byArray[n + 2] & 0xC0) >> 6]);
        this.out.write(table[byArray[n + 2] & 0x3F]);
    }

    private void writeLastBlock() throws IOException {
        if (this.bufferLen == 0) {
            return;
        }
        int n = this.bufferLen;
        while (n < this.buffer.length) {
            this.buffer[n] = 0;
            ++n;
        }
        char[] cArray = new char[]{table[(this.buffer[0] & 0xFC) >> 2], table[(this.buffer[0] & 3) << 4 | (this.buffer[1] & 0xF0) >> 4], table[(this.buffer[1] & 0xF) << 2 | (this.buffer[2] & 0xC0) >> 6], table[this.buffer[2] & 0x3F]};
        switch (this.bufferLen) {
            case 1: {
                cArray[2] = 61;
                cArray[3] = 61;
                break;
            }
            case 2: {
                cArray[3] = 61;
                break;
            }
        }
        this.out.write(new String(cArray).getBytes());
    }
}

