/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;

public class Extension
extends Sequence {
    protected String extnID;
    protected boolean critical = false;
    protected byte[] extnValue;
    protected byte[] value;

    public Extension() {
    }

    public Extension(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.extnID = ((Oid)this.components.elementAt(n++)).getOid();
        try {
            this.critical = ((Boolean)this.components.elementAt(n)).getTruth();
            ++n;
        }
        catch (ClassCastException classCastException) {}
        this.extnValue = ((OctetString)this.components.elementAt(n)).encode();
        this.value = ((OctetString)this.components.elementAt(n)).getBytes();
    }

    public String getExtnID() {
        return this.extnID;
    }

    public byte[] getExtnValue() {
        return this.extnValue;
    }

    public boolean isCritical() {
        return this.critical;
    }

    protected static String printHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Extension.toHexDigit(byArray[n]));
            ++n;
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static String toHexDigit(byte by) {
        char[] cArray = new char[2];
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[0] = c;
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[1] = c;
        return new String(cArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Unknown Extension:\n");
        stringBuffer.append("  OID:" + this.extnID + "\n");
        return stringBuffer.toString();
    }
}

