/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.extns.AuthorityKeyIdentifier;
import com.dstc.security.x509.extns.BasicConstraints;
import com.dstc.security.x509.extns.IssuerAltName;
import com.dstc.security.x509.extns.KeyUsage;
import com.dstc.security.x509.extns.NetscapeCertType;
import com.dstc.security.x509.extns.SubjectAltName;
import com.dstc.security.x509.extns.SubjectKeyIdentifier;
import java.security.cert.X509Certificate;

public class ExtensionFactory {
    public static Extension getExtension(String string, X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        Sequence sequence = new Sequence();
        try {
            sequence.addComponent(new Oid(string));
            sequence.addComponent(Asn1.decode(byArray));
        }
        catch (Asn1Exception asn1Exception) {
            asn1Exception.printStackTrace();
            return null;
        }
        return ExtensionFactory.getExtension(sequence.encode());
    }

    public static Extension getExtension(byte[] byArray) {
        try {
            Extension extension = new Extension(byArray);
            if (extension.getExtnID().equals("2.16.840.1.113730.1.1")) {
                return new NetscapeCertType(byArray);
            }
            if (extension.getExtnID().equals("2.5.29.19")) {
                return new BasicConstraints(byArray);
            }
            if (extension.getExtnID().equals("2.5.29.35")) {
                return new AuthorityKeyIdentifier(byArray);
            }
            if (extension.getExtnID().equals("2.5.29.14")) {
                return new SubjectKeyIdentifier(byArray);
            }
            if (extension.getExtnID().equals("2.5.29.15")) {
                return new KeyUsage(byArray);
            }
            if (extension.getExtnID().equals("2.5.29.18")) {
                return new IssuerAltName(byArray);
            }
            if (extension.getExtnID().equals("2.5.29.17")) {
                return new SubjectAltName(byArray);
            }
            return extension;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

