/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.ExtensionFactory;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Extensions
extends Sequence {
    private Vector extns;

    public Extensions(Vector vector) throws Asn1Exception {
        this.extns = vector;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            this.addComponent(new Extension(((Asn1)iterator.next()).encode()));
        }
    }

    public Extensions(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.extns = new Vector();
        int n = 0;
        while (n < this.components.size()) {
            this.extns.add(ExtensionFactory.getExtension(((Asn1)this.components.elementAt(n)).encode()));
            ++n;
        }
    }

    public Set getCriticalOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ((AbstractList)this.extns).iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtnID());
        }
        return hashSet;
    }

    public Set getNonCriticalOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ((AbstractList)this.extns).iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtnID());
        }
        return hashSet;
    }

    public byte[] getValue(String string) {
        Iterator iterator = ((AbstractList)this.extns).iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.getExtnID().equals(string)) continue;
            return extension.getExtnValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.extns).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Extension)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }
}

