/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.Primitive;

public class GeneralName
extends Primitive {
    public static final int RFC822NAME = 1;
    public static final int DNSNAME = 2;
    private int type;
    private String name;

    private GeneralName(byte by, Asn1 asn1) {
        super(by, asn1);
    }

    public GeneralName(int n, String string) {
        this(GeneralName.tag(n), GeneralName.orig(n, string));
        this.type = n;
        this.name = string;
    }

    public GeneralName(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.type = this.getTagNumber();
        this.name = new String(this.contents);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    private static final Asn1 orig(int n, String string) {
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                return new IA5String(string);
            }
        }
        return null;
    }

    private static final byte tag(int n) {
        return (byte)(n | 0xFFFFFF80);
    }
}

