/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.x509.AttributeTypeAndValue;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RDN
extends SetOf
implements Comparable {
    private static Hashtable orderedTypes = new Hashtable();
    private Vector rdnComponents = new Vector();

    static {
        orderedTypes.put("C", "A");
        orderedTypes.put("ST", "B");
        orderedTypes.put("L", "C");
        orderedTypes.put("O", "D");
        orderedTypes.put("OU", "E");
        orderedTypes.put("CN", "F");
        orderedTypes.put("EmailAddress", "H");
    }

    public RDN(String string) throws IOException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "=", false);
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = stringTokenizer.nextToken().trim();
            AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(string2, string3);
            this.rdnComponents.addElement(attributeTypeAndValue);
            this.addComponent(attributeTypeAndValue);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public RDN(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        while (n < this.components.size()) {
            this.rdnComponents.addElement(new AttributeTypeAndValue(((Asn1)this.components.elementAt(n)).encode()));
            ++n;
        }
    }

    public int compareTo(Object object) {
        return this.getTypeOrder().compareTo(((RDN)object).getTypeOrder());
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.rdnComponents.size()) {
            stringBuffer.append(((AttributeTypeAndValue)this.rdnComponents.elementAt(n)).getName());
            ++n;
        }
        return stringBuffer.toString();
    }

    private String getTypeOrder() {
        return (String)orderedTypes.get(((AttributeTypeAndValue)((AbstractList)this.rdnComponents).iterator().next()).getType());
    }
}

