/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.x509.Extensions;
import java.math.BigInteger;

public class RevokedCertificate
extends Sequence {
    private BigInteger userCertificate;
    private UTCTime revocationDate;
    private Extensions crlExtns = null;

    public RevokedCertificate(BigInteger bigInteger, UTCTime uTCTime, Extensions extensions) {
        this.userCertificate = bigInteger;
        this.addComponent(new Integer(bigInteger));
        this.revocationDate = uTCTime;
        this.addComponent(uTCTime);
        if (extensions == null) {
            return;
        }
        this.crlExtns = extensions;
        this.addComponent(extensions);
    }

    public RevokedCertificate(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.userCertificate = ((Integer)this.components.elementAt(n++)).getBigInteger();
        this.revocationDate = (UTCTime)this.components.elementAt(n++);
        if (n == this.components.size()) {
            return;
        }
        this.crlExtns = new Extensions(((Asn1)this.components.elementAt(n++)).encode());
    }

    public Extensions getCrlExtns() {
        return this.crlExtns;
    }

    public UTCTime getRevocationDate() {
        return this.revocationDate;
    }

    public BigInteger getSerialNumber() {
        return this.userCertificate;
    }
}

