/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.AlgorithmId;

public class SubjectPublicKeyInfo
extends Sequence {
    private AlgorithmId algoId;
    private byte[] encodedKey;

    public SubjectPublicKeyInfo(AlgorithmId algorithmId, byte[] byArray) {
        this.algoId = algorithmId;
        this.addComponent(algorithmId);
        this.encodedKey = byArray;
        this.addComponent(new BitString(byArray));
    }

    public SubjectPublicKeyInfo(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.algoId = new AlgorithmId(((Sequence)this.components.elementAt(0)).encode());
        this.encodedKey = ((BitString)this.components.elementAt(1)).getBytes();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algoId;
    }

    public byte[] getEncodedKey() {
        return this.encodedKey;
    }
}

