/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import com.dstc.security.x509.Validity;
import com.dstc.security.x509.X500Name;
import java.math.BigInteger;

final class TBSCertificate
extends Sequence {
    private int version = 0;
    private BigInteger serialNumber;
    private X500Name issuer;
    private X500Name subject;
    private Validity validity;
    private AlgorithmId algo;
    private SubjectPublicKeyInfo spki;
    private byte[] issuerUniqueId;
    private byte[] subjectUniqueId;
    private Extensions extns = null;

    TBSCertificate(int n, BigInteger bigInteger, AlgorithmId algorithmId, X500Name x500Name, Validity validity, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo, Extensions extensions) {
        Explicit explicit;
        if (n != 0) {
            this.version = n;
            explicit = new Explicit(-128, 0);
            explicit.addComponent(new Integer(this.version));
            this.addComponent(explicit);
        }
        this.serialNumber = bigInteger;
        this.addComponent(new Integer(this.serialNumber));
        this.algo = algorithmId;
        this.addComponent(this.algo);
        this.issuer = x500Name;
        this.addComponent(this.issuer);
        this.validity = validity;
        this.addComponent(this.validity);
        this.subject = x500Name2;
        this.addComponent(this.subject);
        this.spki = subjectPublicKeyInfo;
        this.addComponent(this.spki);
        if (extensions != null) {
            this.extns = extensions;
            explicit = new Explicit(-128, 3);
            explicit.addComponent(extensions);
            this.addComponent(explicit);
        }
    }

    TBSCertificate(byte[] byArray) throws Asn1Exception {
        Explicit explicit;
        int n = 0;
        this.doDecode(byArray);
        try {
            explicit = (Explicit)this.components.elementAt(n);
            if (explicit.getTagNumber() != 0) {
                throw new Asn1Exception("Bad Tag Num");
            }
            this.version = ((Integer)explicit.getComponent()).getInt();
        }
        catch (ClassCastException classCastException) {}
        int n2 = ++n;
        this.serialNumber = ((Integer)this.components.elementAt(n2)).getBigInteger();
        int n3 = ++n;
        this.algo = new AlgorithmId(((Asn1)this.components.elementAt(n3)).encode());
        int n4 = ++n;
        this.issuer = new X500Name(((Asn1)this.components.elementAt(n4)).encode());
        int n5 = ++n;
        this.validity = new Validity(((Asn1)this.components.elementAt(n5)).encode());
        int n6 = ++n;
        this.subject = new X500Name(((Asn1)this.components.elementAt(n6)).encode());
        int n7 = ++n;
        this.spki = new SubjectPublicKeyInfo(((Asn1)this.components.elementAt(n7)).encode());
        if (++n == this.components.size()) {
            return;
        }
        explicit = (Explicit)this.components.elementAt(n);
        if (explicit.getTagNumber() == 1) {
            this.issuerUniqueId = ((BitString)explicit.getComponent()).getBytes();
            if (++n == this.components.size()) {
                return;
            }
        }
        if ((explicit = (Explicit)this.components.elementAt(n)).getTagNumber() == 2) {
            this.subjectUniqueId = ((BitString)explicit.getComponent()).getBytes();
            if (++n == this.components.size()) {
                return;
            }
        }
        if ((explicit = (Explicit)this.components.elementAt(n)).getTagNumber() == 3) {
            this.extns = new Extensions(explicit.getComponent().encode());
        }
    }

    Extensions getExtensions() {
        return this.extns;
    }

    X500Name getIssuer() {
        return this.issuer;
    }

    BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    X500Name getSubject() {
        return this.subject;
    }

    SubjectPublicKeyInfo getSubjectPubKeyInfo() {
        return this.spki;
    }

    Validity getValidity() {
        return this.validity;
    }

    int getVersion() {
        return this.version;
    }
}

