/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Validity
extends Sequence {
    private String notBefore;
    private String notAfter;

    public Validity(int n) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(calendar.get(1)).substring(2, 4));
        this.append(stringBuffer, calendar.get(2) + 1);
        this.append(stringBuffer, calendar.get(5));
        this.append(stringBuffer, calendar.get(10));
        this.append(stringBuffer, calendar.get(12));
        stringBuffer.append("Z");
        this.notBefore = stringBuffer.toString();
        this.addComponent(new UTCTime(this.notBefore));
        calendar.add(5, n);
        stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(calendar.get(1)).substring(2, 4));
        this.append(stringBuffer, calendar.get(2) + 1);
        this.append(stringBuffer, calendar.get(5));
        this.append(stringBuffer, calendar.get(10));
        this.append(stringBuffer, calendar.get(12));
        stringBuffer.append("Z");
        this.notAfter = stringBuffer.toString();
        this.addComponent(new UTCTime(this.notAfter));
    }

    Validity(String string, String string2) {
        this.notBefore = string;
        this.addComponent(new UTCTime(string));
        this.notAfter = string2;
        this.addComponent(new UTCTime(string2));
    }

    Validity(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.notBefore = ((UTCTime)this.components.elementAt(0)).getTime();
        this.notAfter = ((UTCTime)this.components.elementAt(1)).getTime();
    }

    private void append(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append("0" + n);
        } else {
            stringBuffer.append(n);
        }
    }

    static final Date getDate(String string) {
        Date date = null;
        if (string.endsWith("Z")) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            switch (string.length()) {
                case 11: {
                    int n = Integer.parseInt(string.substring(0, 2));
                    int n2 = n > 50 ? 1900 + n : 2000 + n;
                    int n3 = Integer.parseInt(string.substring(2, 4)) - 1;
                    int n4 = Integer.parseInt(string.substring(4, 6));
                    int n5 = Integer.parseInt(string.substring(6, 8));
                    int n6 = Integer.parseInt(string.substring(8, 10));
                    calendar.set(n2, n3, n4, n5, n6);
                    break;
                }
                case 13: {
                    int n = Integer.parseInt(string.substring(0, 2));
                    int n7 = n > 50 ? 1900 + n : 2000 + n;
                    int n8 = Integer.parseInt(string.substring(2, 4)) - 1;
                    int n9 = Integer.parseInt(string.substring(4, 6));
                    int n10 = Integer.parseInt(string.substring(6, 8));
                    int n11 = Integer.parseInt(string.substring(8, 10));
                    int n12 = Integer.parseInt(string.substring(10, 12));
                    calendar.set(n7, n8, n9, n10, n11, n12);
                    break;
                }
            }
            date = calendar.getTime();
        }
        return date;
    }

    Date getNotAfter() {
        return Validity.getDate(this.notAfter);
    }

    Date getNotBefore() {
        return Validity.getDate(this.notBefore);
    }

    public String toString() {
        return "Not Before: " + this.notBefore + "\n" + "Not After:   " + this.notAfter;
    }
}

