/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.RDN;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;

public class X500Name
extends Sequence
implements Principal {
    private Vector rdns = new Vector();

    public X500Name(String string) throws IOException {
        RDN rDN;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String string2 = stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf(61) == -1) {
                stringBuffer.append(",").append(string2);
                continue;
            }
            rDN = new RDN(stringBuffer.toString());
            this.rdns.addElement(rDN);
            stringBuffer = new StringBuffer(string2);
        }
        rDN = new RDN(stringBuffer.toString());
        this.rdns.addElement(rDN);
        Iterator iterator = new TreeSet(this.rdns).iterator();
        while (iterator.hasNext()) {
            this.addComponent((RDN)iterator.next());
        }
    }

    public X500Name(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        while (n < this.components.size()) {
            this.rdns.addElement(new RDN(((Asn1)this.components.elementAt(n)).encode()));
            ++n;
        }
    }

    public boolean equals(Object object) {
        try {
            String string = ((X500Name)object).getName();
            return this.getName().equals(string);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = new TreeSet(this.rdns).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((RDN)iterator.next()).getName());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public Vector getRDNs() {
        return this.rdns;
    }

    public int hashcode() {
        return 0;
    }
}

