/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.x509.RevokedCertificate;
import com.dstc.security.x509.Validity;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Date;
import java.util.Set;

public class X509CRLEntryImpl
extends X509CRLEntry {
    private RevokedCertificate revCert;

    public X509CRLEntryImpl(byte[] byArray) throws Asn1Exception {
        this.revCert = new RevokedCertificate(byArray);
    }

    public Set getCriticalExtensionOIDs() {
        return this.revCert.getCrlExtns().getCriticalOIDs();
    }

    public byte[] getEncoded() throws CRLException {
        return this.revCert.encode();
    }

    public byte[] getExtensionValue(String string) {
        return this.revCert.getCrlExtns().getValue(string);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.revCert.getCrlExtns().getNonCriticalOIDs();
    }

    public Date getRevocationDate() {
        return Validity.getDate(this.revCert.getRevocationDate().getTime());
    }

    public BigInteger getSerialNumber() {
        return this.revCert.getSerialNumber();
    }

    public boolean hasExtensions() {
        return this.revCert.getCrlExtns() != null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public String toString() {
        return "Not yet implemented";
    }
}

