/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.RevokedCertificate;
import com.dstc.security.x509.X500Name;
import com.dstc.security.x509.X509CRLEntryImpl;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class X509CRLImpl
extends X509CRL {
    private CertificateList certList;

    public X509CRLImpl(String string, X500Name x500Name, UTCTime uTCTime, UTCTime uTCTime2, Set set, Extensions extensions, PrivateKey privateKey) {
        this.certList = new CertificateList(string, x500Name, uTCTime, uTCTime2, set, extensions, privateKey);
    }

    public X509CRLImpl(byte[] byArray) throws Asn1Exception {
        this.certList = new CertificateList(byArray);
    }

    public Set getCriticalExtensionOIDs() {
        return this.certList.tbsCertList.extns.getCriticalOIDs();
    }

    public byte[] getEncoded() throws CRLException {
        return this.certList.encode();
    }

    public byte[] getExtensionValue(String string) {
        return this.certList.tbsCertList.extns.getValue(string);
    }

    public Principal getIssuerDN() {
        return this.certList.tbsCertList.issuer;
    }

    public Date getNextUpdate() {
        return this.certList.tbsCertList.nextUpdate.getDate();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.certList.tbsCertList.extns.getNonCriticalOIDs();
    }

    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        try {
            Iterator iterator = this.getRevokedCertificates().iterator();
            while (iterator.hasNext()) {
                X509CRLEntryImpl x509CRLEntryImpl = new X509CRLEntryImpl(((RevokedCertificate)iterator.next()).encode());
                if (!((X509CRLEntry)x509CRLEntryImpl).getSerialNumber().equals(bigInteger)) continue;
                return x509CRLEntryImpl;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Set getRevokedCertificates() {
        return this.certList.tbsCertList.revCerts.certs;
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.certList.sigAlg.getOid());
    }

    public String getSigAlgOID() {
        return this.certList.sigAlg.getOid();
    }

    public byte[] getSigAlgParams() {
        try {
            return this.certList.sigAlg.getParams().getEncoded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getSignature() {
        return this.certList.signature;
    }

    public byte[] getTBSCertList() throws CRLException {
        return this.certList.tbsCertList.encode();
    }

    public Date getThisUpdate() {
        return this.certList.tbsCertList.thisUpdate.getDate();
    }

    public int getVersion() {
        return this.certList.tbsCertList.version;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public boolean isRevoked(Certificate certificate) {
        return this.getRevokedCertificate(((X509Certificate)certificate).getSerialNumber()) != null;
    }

    public String toString() {
        return "Not yet implemented";
    }

    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "DSTC");
    }

    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = Signature.getInstance(this.getSigAlgName(), string);
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        boolean bl = signature.verify(this.getSignature());
        System.out.println("Signature verifies: " + bl);
    }

    protected class CertificateList
    extends Sequence {
        private TbsCertList tbsCertList;
        private AlgorithmId sigAlg;
        private byte[] signature;

        protected CertificateList(String string, X500Name x500Name, UTCTime uTCTime, UTCTime uTCTime2, Set set, Extensions extensions, PrivateKey privateKey) {
            try {
                this.tbsCertList = new TbsCertList(string, x500Name, uTCTime, uTCTime2, set, extensions);
                this.addComponent(this.tbsCertList);
                this.sigAlg = new AlgorithmId(string, null);
                this.addComponent(this.sigAlg);
                Signature signature = Signature.getInstance(string);
                signature.initSign(privateKey);
                signature.update(this.tbsCertList.encode());
                this.signature = signature.sign();
                this.addComponent(new BitString(this.signature));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected CertificateList(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.tbsCertList = new TbsCertList(((Asn1)this.components.elementAt(0)).encode());
            this.sigAlg = new AlgorithmId(((Asn1)this.components.elementAt(1)).encode());
            this.signature = ((BitString)this.components.elementAt(2)).getBytes();
        }

        protected class TbsCertList
        extends Sequence {
            private int version = 1;
            private AlgorithmId sigAlgo;
            private X500Name issuer;
            private UTCTime thisUpdate;
            private UTCTime nextUpdate;
            private RevokedCertificates revCerts;
            private Extensions extns;

            protected TbsCertList(String string, X500Name x500Name, UTCTime uTCTime, UTCTime uTCTime2, Set set, Extensions extensions) {
                try {
                    this.addComponent(new Integer(this.version));
                    this.sigAlgo = new AlgorithmId(string, null);
                    this.addComponent(this.sigAlgo);
                    this.issuer = x500Name;
                    this.addComponent(x500Name);
                    this.thisUpdate = uTCTime;
                    this.addComponent(uTCTime);
                    this.nextUpdate = uTCTime2;
                    this.addComponent(uTCTime2);
                    CertificateList certificateList2 = CertificateList.this;
                    certificateList2.getClass();
                    this.revCerts = certificateList2.new RevokedCertificates(set);
                    this.addComponent(this.revCerts);
                    if (extensions != null) {
                        this.extns = extensions;
                        Explicit explicit = new Explicit(-128, 0);
                        explicit.addComponent(extensions);
                        this.addComponent(explicit);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            protected TbsCertList(byte[] byArray) throws Asn1Exception {
                this.doDecode(byArray);
                int n = 0;
                try {
                    this.version = ((Integer)this.components.elementAt(n)).getInt();
                }
                catch (ClassCastException classCastException) {}
                int n2 = ++n;
                this.sigAlgo = new AlgorithmId(((Asn1)this.components.elementAt(n2)).encode());
                int n3 = ++n;
                this.issuer = new X500Name(((Asn1)this.components.elementAt(n3)).encode());
                int n4 = ++n;
                this.thisUpdate = (UTCTime)this.components.elementAt(n4);
                int n5 = ++n;
                this.nextUpdate = (UTCTime)this.components.elementAt(n5);
                CertificateList certificateList2 = CertificateList.this;
                certificateList2.getClass();
                int n6 = ++n;
                this.revCerts = certificateList2.new RevokedCertificates(((Asn1)this.components.elementAt(n6)).encode());
                if (++n == this.components.size()) {
                    return;
                }
                this.extns = new Extensions(((Explicit)this.components.elementAt(n)).getComponent().encode());
            }
        }

        protected class RevokedCertificates
        extends Sequence {
            private HashSet certs = new HashSet();

            protected RevokedCertificates(Set set) {
                this.certs = new HashSet(set);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.addComponent((RevokedCertificate)iterator.next());
                }
            }

            protected RevokedCertificates(byte[] byArray) throws Asn1Exception {
                this.doDecode(byArray);
                int n = 0;
                while (n < this.components.size()) {
                    this.certs.add(new RevokedCertificate(((Asn1)this.components.elementAt(n)).encode()));
                    ++n;
                }
            }
        }
    }
}

