/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.SubjectPublicKeyInfo;
import com.dstc.security.x509.TBSCertificate;
import com.dstc.security.x509.Validity;
import com.dstc.security.x509.X500Name;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class X509CertImpl
extends X509Certificate {
    private Certificate cert;

    public X509CertImpl(int n, BigInteger bigInteger, X500Name x500Name, Validity validity, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo, String string, PrivateKey privateKey, Extensions extensions) {
        this.cert = new Certificate(n, bigInteger, x500Name, validity, x500Name2, subjectPublicKeyInfo, string, privateKey, extensions);
    }

    public X509CertImpl(byte[] byArray) throws Asn1Exception {
        this.cert = new Certificate(byArray);
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("Certficate Expired on: " + this.getNotAfter());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("Certficate Not Valid until " + this.getNotBefore());
        }
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("Certficate Expires on: " + this.getNotAfter());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("Certficate Not Valid until " + this.getNotBefore());
        }
    }

    public int getBasicConstraints() {
        return 0;
    }

    public Set getCriticalExtensionOIDs() {
        if (this.cert.tbs.getExtensions() == null) {
            return new HashSet();
        }
        return this.cert.tbs.getExtensions().getCriticalOIDs();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.cert.encode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CertificateEncodingException(exception.toString());
        }
    }

    public byte[] getExtensionValue(String string) {
        if (this.cert.tbs.getExtensions() == null) {
            return null;
        }
        return this.cert.tbs.getExtensions().getValue(string);
    }

    public Principal getIssuerDN() {
        return this.cert.tbs.getIssuer();
    }

    public boolean[] getIssuerUniqueID() {
        return null;
    }

    public boolean[] getKeyUsage() {
        byte[] byArray = this.getExtensionValue("2.5.29.15");
        if (byArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[8];
        int n = 0;
        while (n < 8) {
            blArray[n] = (byArray[0] >>> n & 1) != 0;
            ++n;
        }
        return blArray;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.cert.tbs.getExtensions() == null) {
            return new HashSet();
        }
        return this.cert.tbs.getExtensions().getNonCriticalOIDs();
    }

    public Date getNotAfter() {
        return this.cert.tbs.getValidity().getNotAfter();
    }

    public Date getNotBefore() {
        return this.cert.tbs.getValidity().getNotBefore();
    }

    public PublicKey getPublicKey() {
        try {
            String string = OID.getAlgName(this.cert.tbs.getSubjectPubKeyInfo().getAlgorithmId().getOid());
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            return keyFactory.generatePublic(new X509EncodedKeySpec(this.cert.tbs.getSubjectPubKeyInfo().encode()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BigInteger getSerialNumber() {
        return this.cert.tbs.getSerialNumber();
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.cert.sigAlg.getOid());
    }

    public String getSigAlgOID() {
        return this.cert.sigAlg.getOid();
    }

    public byte[] getSigAlgParams() {
        try {
            return this.cert.sigAlg.getParams().getEncoded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte[] getSignature() {
        return this.cert.sigData;
    }

    public Principal getSubjectDN() {
        return this.cert.tbs.getSubject();
    }

    public boolean[] getSubjectUniqueID() {
        return null;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.cert.tbs.encode();
        }
        catch (Exception exception) {
            throw new CertificateEncodingException(exception.toString());
        }
    }

    public int getVersion() {
        return this.cert.tbs.getVersion() + 1;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.getVersion() + "\n");
        stringBuffer.append("Serial Number: " + this.getSerialNumber().toString() + "\n");
        stringBuffer.append("Issuer: " + this.getIssuerDN().getName() + "\n");
        stringBuffer.append("Subject: " + this.getSubjectDN().getName() + "\n");
        stringBuffer.append("Key Algorithm: " + this.getPublicKey().getAlgorithm() + "\n");
        stringBuffer.append("Signature Algorithm: " + this.getSigAlgName());
        stringBuffer.append(" (" + this.getSigAlgOID() + ")\n");
        stringBuffer.append("Valid Not Before: " + this.getNotBefore() + "\n");
        stringBuffer.append("Valid Not After: " + this.getNotAfter() + "\n");
        if (this.cert.tbs.getExtensions() != null) {
            stringBuffer.append(this.cert.tbs.getExtensions().toString());
        }
        return stringBuffer.toString();
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "DSTC");
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            Signature signature = Signature.getInstance(this.getSigAlgName(), string);
            signature.initVerify(publicKey);
            signature.update(this.getTBSCertificate());
            boolean bl = signature.verify(this.getSignature());
            if (!bl) {
                throw new CertificateException("Bad signature");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CertificateException(exception.toString());
        }
    }

    protected class Certificate
    extends Sequence {
        private TBSCertificate tbs;
        private AlgorithmId sigAlg;
        private byte[] sigData;

        protected Certificate(int n, BigInteger bigInteger, X500Name x500Name, Validity validity, X500Name x500Name2, SubjectPublicKeyInfo subjectPublicKeyInfo, String string, PrivateKey privateKey, Extensions extensions) {
            try {
                this.sigAlg = new AlgorithmId(OID.getAlgOid(string));
                this.tbs = new TBSCertificate(n, bigInteger, this.sigAlg, x500Name, validity, x500Name2, subjectPublicKeyInfo, extensions);
                this.addComponent(this.tbs);
                this.addComponent(this.sigAlg);
                Signature signature = Signature.getInstance(string);
                signature.initSign(privateKey);
                signature.update(this.tbs.encode());
                this.sigData = signature.sign();
                this.addComponent(new BitString(this.sigData));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected Certificate(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            this.tbs = new TBSCertificate(((Asn1)this.components.elementAt(0)).encode());
            this.sigAlg = new AlgorithmId(((Asn1)this.components.elementAt(1)).encode());
            this.sigData = ((BitString)this.components.elementAt(2)).getBytes();
        }
    }
}

