/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.v1.ContentInfo;
import com.dstc.security.cms.v1.SignedData;
import com.dstc.security.x509.Base64InputStream;
import com.dstc.security.x509.X509CRLImpl;
import com.dstc.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class X509CertificateFactory
extends CertificateFactorySpi {
    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        try {
            byte[] byArray = new byte[1000];
            inputStream.read(byArray);
            return new X509CRLImpl(byArray);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
        catch (Asn1Exception asn1Exception) {
            throw new CRLException(asn1Exception.toString());
        }
    }

    public Collection engineGenerateCRLs(InputStream inputStream) throws CRLException {
        try {
            byte[] byArray = new byte[2000];
            inputStream.read(byArray);
            ContentInfo contentInfo = new ContentInfo(byArray);
            if (!contentInfo.getContentType().equals("1.2.840.113549.1.7.2")) {
                throw new CRLException("Not a PKCS#7 SignedData");
            }
            SignedData signedData = new SignedData(contentInfo.getContent().encode());
            return signedData.getCRLs();
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
        catch (Asn1Exception asn1Exception) {
            throw new CRLException(asn1Exception.toString());
        }
    }

    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        inputStream.mark(30);
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            return new X509CertImpl(byArray);
        }
        catch (Exception exception) {
            try {
                inputStream.reset();
                Base64InputStream base64InputStream = new Base64InputStream(inputStream, "-----BEGIN CERTIFICATE-----", "-----END CERTIFICATE-----");
                byte[] byArray = new byte[base64InputStream.available()];
                base64InputStream.read(byArray);
                return new X509CertImpl(byArray);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                throw new CertificateException("Error parsing certificate");
            }
        }
    }

    public Collection engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            ContentInfo contentInfo = new ContentInfo(byArray);
            if (!contentInfo.getContentType().equals("1.2.840.113549.1.7.2")) {
                throw new CertificateException("Not a PKCS#7 SignedData");
            }
            SignedData signedData = new SignedData(contentInfo.getContent().encode());
            return signedData.getCertificates();
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.toString());
        }
        catch (Asn1Exception asn1Exception) {
            throw new CertificateException(asn1Exception.toString());
        }
    }
}

