/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Primitive;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.GeneralNames;
import java.math.BigInteger;
import java.util.Vector;

public class AuthorityKeyIdentifier
extends Extension {
    private byte[] keyId;
    private GeneralNames issuer;
    private BigInteger serialNumber;

    public AuthorityKeyIdentifier(GeneralNames generalNames, BigInteger bigInteger) {
        this.extnID = "2.5.29.35";
        this.addComponent(new Oid(this.extnID));
        this.issuer = generalNames;
        this.serialNumber = bigInteger;
        Sequence sequence = new Sequence();
        generalNames.setTagClass((byte)-128);
        generalNames.setTagNumber(1);
        sequence.addComponent(generalNames);
        Integer integer = new Integer(bigInteger);
        integer.setTagClass((byte)-128);
        integer.setTagNumber(2);
        sequence.addComponent(integer);
        this.extnValue = sequence.encode();
        this.addComponent(new OctetString(this.extnValue));
    }

    public AuthorityKeyIdentifier(boolean bl, byte[] byArray) {
        this.extnID = "2.5.29.35";
        this.addComponent(new Oid(this.extnID));
        this.keyId = byArray;
        Sequence sequence = new Sequence();
        OctetString octetString = new OctetString(byArray);
        octetString.setTagClass((byte)-128);
        octetString.setTagNumber(0);
        sequence.addComponent(octetString);
        this.extnValue = sequence.encode();
        this.addComponent(new OctetString(this.extnValue));
    }

    public AuthorityKeyIdentifier(byte[] byArray) throws Asn1Exception {
        super(byArray);
        Sequence sequence = (Sequence)Asn1.decode(this.value);
        Vector vector = sequence.getComponents();
        int n = 0;
        try {
            Primitive primitive = (Primitive)vector.elementAt(n);
            this.keyId = primitive.getBytes();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AuthorityKeyIdentifier extension:\n");
        stringBuffer.append("  " + Extension.printHex(this.keyId));
        return stringBuffer.toString();
    }
}

