/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.Extension;

public class BasicConstraints
extends Extension {
    private IBasicConstraints constr;

    public BasicConstraints(boolean bl, boolean bl2, int n) {
        this.extnID = "2.5.29.19";
        this.addComponent(new Oid("2.5.29.19"));
        if (bl) {
            this.critical = bl;
            this.addComponent(new Boolean(1));
        }
        this.constr = new IBasicConstraints(bl2, n);
        this.addComponent(new OctetString(this.constr.encode()));
    }

    public BasicConstraints(byte[] byArray) throws Asn1Exception {
        super(byArray);
        this.constr = new IBasicConstraints(this.value);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BasicConstraints extension:\n");
        if (this.constr.isCA) {
            stringBuffer.append("  CA, ");
        }
        stringBuffer.append("Path Length Constraint = ");
        if (this.constr.len > 0) {
            stringBuffer.append(String.valueOf(this.constr.len) + "\n");
        } else {
            stringBuffer.append("unspecified\n");
        }
        return stringBuffer.toString();
    }

    protected class IBasicConstraints
    extends Sequence {
        protected int len = -1;
        protected boolean isCA = false;

        protected IBasicConstraints(boolean bl, int n) {
            if (bl) {
                this.isCA = true;
                this.addComponent(new Boolean(1));
            }
            if (n > 0) {
                this.len = n;
                this.addComponent(new Integer(n));
            }
        }

        protected IBasicConstraints(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            int n = 0;
            if (n >= this.components.size()) {
                return;
            }
            try {
                this.isCA = ((Boolean)this.components.elementAt(n)).getTruth();
                ++n;
            }
            catch (ClassCastException classCastException) {}
            if (n >= this.components.size()) {
                return;
            }
            this.len = ((Integer)this.components.elementAt(n)).getInt();
        }
    }
}

