/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.x509.Extension;

public class KeyUsage
extends Extension {
    public static final short DIGITAL_SIGNATURE = Short.MIN_VALUE;
    public static final short NON_REPUDIATION = 16384;
    public static final short KEY_ENCIPHERMENT = 8192;
    public static final short DATA_ENCIPHERMENT = 4096;
    public static final short KEY_AGREEMENT = 2048;
    public static final short KEY_CERT_SIGN = 1024;
    public static final short CRL_SIGN = 512;
    public static final short ENCIPHER_ONLY = 256;
    public static final short DECIPHER_ONLY = 128;
    private short usage;

    public KeyUsage(short s) {
        this.extnID = "2.5.29.15";
        this.usage = s;
        this.addComponent(new Oid("2.5.29.15"));
        this.critical = true;
        this.addComponent(new Boolean(1));
        byte[] byArray = new byte[]{(byte)(s >>> 8 & 0xFF), (byte)(s & 0xFF)};
        this.extnValue = new BitString(byArray).encode();
        this.addComponent(new OctetString(this.extnValue));
    }

    public KeyUsage(byte[] byArray) throws Asn1Exception {
        super(byArray);
        byte[] byArray2 = ((BitString)Asn1.decode(this.value)).getBytes();
        this.usage = (short)(byArray2[0] << 8 & 0xFFFF);
        if (byArray2.length == 2) {
            this.usage = (short)(this.usage | (short)(byArray2[1] & 0xFFFF));
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("KeyUsage extension:\n");
        if ((this.usage & Short.MIN_VALUE) != 0) {
            stringBuffer.append("  DIGITAL SIGNATURE\n");
        }
        if ((this.usage & 0x4000) != 0) {
            stringBuffer.append("  NON REPUDIATION\n");
        }
        if ((this.usage & 0x2000) != 0) {
            stringBuffer.append("  KEY ENCIPHERMENT\n");
        }
        if ((this.usage & 0x1000) != 0) {
            stringBuffer.append("  DATA ENCIPHERMENT\n");
        }
        if ((this.usage & 0x800) != 0) {
            stringBuffer.append("  KEY AGREEMENT\n");
        }
        if ((this.usage & 0x400) != 0) {
            stringBuffer.append("  KEY CERT SIGN\n");
        }
        if ((this.usage & 0x200) != 0) {
            stringBuffer.append("  CRL SIGN\n");
        }
        if ((this.usage & 0x100) != 0) {
            stringBuffer.append("  ENCIPHER ONLY\n");
        }
        if ((this.usage & 0x80) != 0) {
            stringBuffer.append("  DECIPHER ONLY\n");
        }
        return stringBuffer.toString();
    }
}

