/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.x509.Extension;

public class NetscapeCertType
extends Extension {
    public static final byte SSL_CLIENT = -128;
    public static final byte SSL_SERVER = 64;
    public static final byte SMIME = 32;
    public static final byte OBJECT_SIGNING = 16;
    public static final byte SSL_CA = 4;
    public static final byte SMIME_CA = 2;
    public static final byte OBJECT_SIGNING_CA = 1;
    private byte val;

    public NetscapeCertType(boolean bl, byte by) {
        this.extnID = "2.16.840.1.113730.1.1";
        this.addComponent(new Oid(this.extnID));
        if (bl) {
            this.critical = bl;
            this.addComponent(new Boolean(1));
        }
        this.val = by;
        byte[] byArray = new byte[]{by};
        this.extnValue = new BitString(byArray).encode();
        this.addComponent(new OctetString(this.extnValue));
    }

    public NetscapeCertType(byte[] byArray) throws Asn1Exception {
        super(byArray);
        this.val = ((BitString)Asn1.decode(this.value)).getBytes()[0];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NetscapeCertType extension:\n");
        if ((this.val & 4) != 0) {
            stringBuffer.append("  SSL CA\n");
        }
        if ((this.val & 0xFFFFFF80) != 0) {
            stringBuffer.append("  SSL CLIENT\n");
        }
        if ((this.val & 0x40) != 0) {
            stringBuffer.append("  SSL SERVER\n");
        }
        if ((this.val & 0x20) != 0) {
            stringBuffer.append("  SMIME\n");
        }
        if ((this.val & 2) != 0) {
            stringBuffer.append("  SMIME CA\n");
        }
        return stringBuffer.toString();
    }
}

