/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    private static final int UNINITIALIZED = 0;
    private int state;
    private String transformation;
    private Provider provider;
    private CipherSpi cipherSpi;

    protected Cipher(CipherSpi cipherSpi, Provider provider, String string) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = string;
        this.state = 0;
    }

    public byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(new byte[0], 0, 0);
    }

    public byte[] doFinal(byte[] byArray) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(byArray, 0, byArray.length);
    }

    public int doFinal(byte[] byArray, int n) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.doFinal(new byte[0], 0, 0, byArray, n);
    }

    public byte[] doFinal(byte[] byArray, int n, int n2) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(byArray, n, n2, byArray2, 0);
    }

    public int doFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        if (byArray2.length - n3 < this.getOutputSize(n2)) {
            throw new ShortBufferException("Output buffer too short");
        }
        return this.cipherSpi.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    public int getBlockSize() {
        return this.cipherSpi.engineGetBlockSize();
    }

    public byte[] getIV() {
        return this.cipherSpi.engineGetIV();
    }

    public static final Cipher getInstance(String string) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] providerArray = Security.getProviders();
        Cipher cipher = null;
        int n = 0;
        while (n < providerArray.length) {
            try {
                cipher = Cipher.getInstance(string, providerArray[n].getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (cipher != null) {
                return cipher;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException(String.valueOf(string) + " not found");
    }

    public static final Cipher getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        try {
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string2 + " not found");
            }
            StringBuffer stringBuffer = new StringBuffer("Cipher.");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
            if (stringTokenizer.countTokens() == 3) {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                stringBuffer.append(string3);
                String string6 = ((Properties)provider).getProperty(stringBuffer.toString());
                Class<?> clazz = Class.forName(string6);
                CipherSpi cipherSpi = (CipherSpi)clazz.newInstance();
                cipherSpi.engineSetMode(string4);
                cipherSpi.engineSetPadding(string5);
                return new Cipher(cipherSpi, provider, string);
            }
            stringBuffer.append(string);
            String string7 = ((Properties)provider).getProperty(stringBuffer.toString());
            Class<?> clazz = Class.forName(string7);
            CipherSpi cipherSpi = (CipherSpi)clazz.newInstance();
            return new Cipher(cipherSpi, provider, string);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Transformation " + string + " not found in provider " + string2);
        }
    }

    public int getOutputSize(int n) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineGetOutputSize(n);
    }

    public final AlgorithmParameters getParameters() {
        return this.cipherSpi.engineGetParameters();
    }

    public void init(int n, Key key) throws InvalidKeyException {
        this.init(n, key, new SecureRandom());
    }

    public void init(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.state = n;
        this.cipherSpi.engineInit(n, key, secureRandom);
    }

    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(n, key, algorithmParameterSpec, new SecureRandom());
    }

    public void init(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = n;
        this.cipherSpi.engineInit(n, key, algorithmParameterSpec, secureRandom);
    }

    public byte[] update(byte[] byArray) throws IllegalStateException {
        return this.update(byArray, 0, byArray.length);
    }

    public byte[] update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2);
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2) throws IllegalStateException, ShortBufferException {
        return this.update(byArray, n, n2, byArray2, 0);
    }

    public int update(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, ShortBufferException {
        if (this.state == 0) {
            throw new IllegalStateException("Cipher not yet initialized");
        }
        if (byArray2.length - n3 < this.getOutputSize(n2)) {
            throw new ShortBufferException("Output buffer too short");
        }
        return this.cipherSpi.engineUpdate(byArray, n, n2, byArray2, n3);
    }
}

