/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;

public class CipherInputStream
extends FilterInputStream {
    private Cipher cipher;
    private byte[] buffer;
    private int blockSize;
    private int bufferStart = 0;
    private int bufferLen = 0;

    protected CipherInputStream(InputStream inputStream) {
        super(inputStream);
        this.cipher = new NullCipher();
        this.blockSize = this.cipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
    }

    public CipherInputStream(InputStream inputStream, Cipher cipher) {
        super(inputStream);
        this.cipher = cipher;
        this.blockSize = cipher.getBlockSize();
        this.buffer = new byte[this.blockSize];
    }

    public int available() throws IOException {
        try {
            return this.cipher.getOutputSize(this.in.available()) + this.bufferLen;
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int n;
        byte[] byArray = new byte[this.cipher.getBlockSize()];
        do {
            if ((n = this.read(byArray, 0, 1)) != -1) continue;
            return -1;
        } while (n != 1);
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        if (n2 <= this.bufferLen) {
            if (byArray != null) {
                System.arraycopy(this.buffer, this.bufferStart, byArray, n, n2);
            }
            this.bufferStart += n2;
            this.bufferLen -= n2;
            return n2;
        }
        int n3 = n2 - this.bufferLen;
        if (byArray != null) {
            System.arraycopy(this.buffer, this.bufferStart, byArray, n, this.bufferLen);
        }
        n += this.bufferLen;
        this.bufferStart = 0;
        this.bufferLen = 0;
        try {
            byte[] byArray2 = new byte[n3];
            int n4 = this.in.read(byArray2, 0, n3);
            if (n4 == -1) {
                int n5 = this.cipher.doFinal(byArray, n);
                if (n + n5 == 0) {
                    return -1;
                }
                return n + n5;
            }
            byte[] byArray3 = new byte[this.cipher.getOutputSize(n3)];
            int n6 = this.cipher.update(byArray2, 0, n4, byArray3, 0);
            if (n3 <= n6) {
                if (byArray != null) {
                    System.arraycopy(byArray3, 0, byArray, n, n3);
                }
                this.bufferLen = n6 - n3;
                System.arraycopy(byArray3, n3, this.buffer, 0, this.bufferLen);
                return n2;
            }
            if (byArray != null) {
                System.arraycopy(byArray3, 0, byArray, n, n6);
            }
            this.bufferLen = 0;
            return n + n6;
        }
        catch (IllegalStateException illegalStateException) {
            return -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(exception.toString());
        }
    }

    public long skip(long l) throws IOException {
        return this.read(null, 0, (int)l);
    }
}

