/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher cipher;

    protected CipherOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.cipher = new NullCipher();
    }

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        this.cipher = cipher;
    }

    public void close() throws IOException {
        try {
            byte[] byArray = this.cipher.doFinal();
            this.out.write(byArray, 0, byArray.length);
            this.out.flush();
            this.out.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        byte[] byArray2 = new byte[this.cipher.getOutputSize(n2)];
        try {
            int n3 = this.cipher.update(byArray, n, n2, byArray2, 0);
            this.out.write(byArray2, 0, n3);
        }
        catch (ShortBufferException shortBufferException) {
            shortBufferException.printStackTrace();
            throw new IOException(shortBufferException.toString());
        }
    }
}

