/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class KeyAgreement {
    public static final int UNINITIALIZED = 0;
    public static final int INITIALIZED = 1;
    public static final int COMPLETED = 2;
    private int state;
    private Provider provider;
    private String algorithm;
    private KeyAgreementSpi delegate;

    protected KeyAgreement(KeyAgreementSpi keyAgreementSpi, Provider provider, String string) {
        this.delegate = keyAgreementSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final Key doPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Agreement not yet initialized");
        }
        if (bl) {
            this.state = 2;
        }
        return this.delegate.engineDoPhase(key, bl);
    }

    public final byte[] generateSecret() throws IllegalStateException {
        if (this.state != 2) {
            throw new IllegalStateException("Agreement not yet completed");
        }
        return this.delegate.engineGenerateSecret();
    }

    public final SecretKey generateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (this.state != 2) {
            throw new IllegalStateException("Agreement not yet completed");
        }
        return this.delegate.engineGenerateSecret(string);
    }

    public final int generateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (this.state != 2) {
            throw new IllegalStateException("Agreement not yet completed");
        }
        return this.delegate.engineGenerateSecret(byArray, n);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyAgreement getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        KeyAgreement keyAgreement = null;
        int n = 0;
        while (n < providerArray.length) {
            try {
                keyAgreement = KeyAgreement.getInstance(string, providerArray[n].getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (keyAgreement != null) {
                return keyAgreement;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("Algorithm not supported");
    }

    public static final KeyAgreement getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string2 + " not found");
            }
            StringBuffer stringBuffer = new StringBuffer("KeyAgreement.");
            stringBuffer.append(string);
            String string3 = ((Properties)provider).getProperty(stringBuffer.toString());
            Class<?> clazz = Class.forName(string3);
            return new KeyAgreement((KeyAgreementSpi)clazz.newInstance(), provider, string);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " not found in provider " + string2);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        this.init(key, new SecureRandom());
    }

    public final void init(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Not a Private Key");
        }
        this.state = 1;
        this.delegate.engineInit(key, secureRandom);
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(key, algorithmParameterSpec, new SecureRandom());
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Not a Private Key");
        }
        this.state = 1;
        this.delegate.engineInit(key, algorithmParameterSpec, secureRandom);
    }
}

