/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGenerator {
    private KeyGeneratorSpi delegate;
    private Provider provider;
    private String algorithm;

    protected KeyGenerator(KeyGeneratorSpi keyGeneratorSpi, Provider provider, String string) {
        this.delegate = keyGeneratorSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public final SecretKey generateKey() {
        return this.delegate.engineGenerateKey();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final KeyGenerator getInstance(String string) throws NoSuchAlgorithmException {
        try {
            return KeyGenerator.getInstance(string, "DSTC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException("Algorithm not supported");
        }
    }

    public static final KeyGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Provider provider = Security.getProvider(string2);
            StringBuffer stringBuffer = new StringBuffer("KeyGenerator.");
            stringBuffer.append(string);
            String string3 = ((Properties)provider).getProperty(stringBuffer.toString());
            Class<?> clazz = Class.forName(string3);
            return new KeyGenerator((KeyGeneratorSpi)clazz.newInstance(), provider, string);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException();
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(int n) {
        this.init(n, new SecureRandom());
    }

    public final void init(int n, SecureRandom secureRandom) {
        this.delegate.engineInit(n, secureRandom);
    }

    public final void init(SecureRandom secureRandom) {
        this.delegate.engineInit(secureRandom);
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.init(algorithmParameterSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.delegate.engineInit(algorithmParameterSpec, secureRandom);
    }
}

