/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac {
    private MacSpi delegate;
    private Provider provider;
    private String algorithm;
    protected int state;
    protected final int UNINITIALIZED = 0;
    protected final int INITIALIZED = 1;

    protected Mac(MacSpi macSpi, Provider provider, String string) {
        this.delegate = macSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.state = 0;
        return this.delegate.engineDoFinal();
    }

    public final byte[] doFinal(byte[] byArray) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.update(byArray);
        this.state = 0;
        return this.delegate.engineDoFinal();
    }

    public final void doFinal(byte[] byArray, int n) throws ShortBufferException, IllegalStateException {
        if (byArray.length - n < this.getMacLength()) {
            throw new ShortBufferException("Buffer too short");
        }
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.state = 0;
        byte[] byArray2 = this.doFinal();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static final Mac getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        Mac mac = null;
        int n = 0;
        while (n < providerArray.length) {
            try {
                mac = Mac.getInstance(string, providerArray[n].getName());
            }
            catch (NoSuchProviderException noSuchProviderException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            if (mac != null) {
                return mac;
            }
            ++n;
        }
        throw new NoSuchAlgorithmException("Algorithm not supported");
    }

    public static final Mac getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        try {
            Provider provider = Security.getProvider(string2);
            if (provider == null) {
                throw new NoSuchProviderException("Provider " + string2 + " not found");
            }
            StringBuffer stringBuffer = new StringBuffer("Mac.");
            stringBuffer.append(string);
            String string3 = ((Properties)provider).getProperty(stringBuffer.toString());
            Class<?> clazz = Class.forName(string3);
            return new Mac((MacSpi)clazz.newInstance(), provider, string);
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " not found in provider " + string2);
        }
    }

    public final int getMacLength() {
        return this.delegate.engineGetMacLength();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            invalidAlgorithmParameterException.printStackTrace();
        }
    }

    public final void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = 1;
        this.delegate.engineInit(key, algorithmParameterSpec);
    }

    public final void reset() {
        this.state = 0;
        this.delegate.engineReset();
    }

    public final void update(byte by) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.delegate.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.delegate.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws IllegalStateException {
        if (this.state != 1) {
            throw new IllegalStateException("Not yet initialized");
        }
        this.delegate.engineUpdate(byArray, n, n2);
    }
}

