/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    private byte[] keyBytes;

    public DESKeySpec(byte[] byArray) throws InvalidKeyException {
        if (byArray.length < 8) {
            throw new InvalidKeyException("Key too short");
        }
        this.keyBytes = new byte[8];
        System.arraycopy(byArray, 0, this.keyBytes, 0, 8);
    }

    public DESKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length - n < 8) {
            throw new InvalidKeyException("Key too short");
        }
        this.keyBytes = new byte[8];
        System.arraycopy(byArray, n, this.keyBytes, 0, 8);
    }

    public byte[] getKey() {
        return this.keyBytes;
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) throws InvalidKeyException {
        int n2 = n;
        while (n2 < byArray.length) {
            int n3 = 0;
            int n4 = 7;
            while (n4 >= 0) {
                n3 += byArray[n2] >>> n4 & 1;
                --n4;
            }
            if (n3 % 2 == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isWeak(byte[] byArray, int n) throws InvalidKeyException {
        return true;
    }
}

