//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.asn1;

/**
 * <p>A class representing the ASN.1 Explicit type.
 *
 * @see com.dstc.security.asn1.Constructed
 * @see com.dstc.security.asn1.Asn1
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class Explicit extends Constructed
{
  public Explicit() 
  {
    super();
  }

  public Explicit(byte classType, int tagNum)
  {
    this.tagNum = tagNum;
    this.classType = classType;
  }

  public static Asn1 decode(byte encoded[], int marks[]) throws Asn1Exception
  {
    Explicit retval = new Explicit();
    retval.doDecode(encoded, marks);

    retval.tagNum = encoded[marks[0]] & MASK_NUMBER;
    retval.classType = ((byte)(encoded[marks[0]] & MASK_CLASS));
    return retval;
  }

  public Asn1 getComponent()
  {
    return (Asn1)this.getComponents().elementAt(0);
  }

  protected void doDecode(byte encoded[], int marks[]) throws Asn1Exception
  {
    super.doDecode(encoded, marks);
    //if (this.components.size() != 1)
    //  throw new Asn1Exception("Has more than one component");

    this.classType = (byte)(encoded[marks[0]] & MASK_CLASS);
    this.tagNum = encoded[marks[0]] & MASK_NUMBER;
  }

  public void info(int dep)
  {
    depth = dep+1;
    spit(); 
    if (this.classType == TAG_CLASS_APPLICATION)
    {
      System.out.println("[APPLICATION " + tagNum + "] {");
    }
    else if (this.classType == TAG_CLASS_CONTEXT)
    {
      System.out.println("[CONTEXT-SPECIFIC " + tagNum + "] {");
    }
    else if (this.classType == TAG_CLASS_UNIVERSAL)
    {
      System.out.println("[" + tagNum + "] {");
    }
    for (int i=0; i<components.size(); i++)
    {
      ((Asn1)components.elementAt(i)).info(depth);
    }
    spit(); System.out.println("}");
  }
}
