//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.asn1;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Date;
import java.util.StringTokenizer;

/**
 * <p>A class representing the ASN.1 type UTCTime.
 *
 * @see com.dstc.security.asn1.Primitive
 * @see com.dstc.security.asn1.Asn1
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public class UTCTime extends Primitive
{
  public UTCTime() 
  {
    tagNum = TAG_UTCTIME;
  }

  /**
   * Constructs a UTCTime from an hour offset (0 for current time)
   */
  public UTCTime(int offset)
  {
    tagNum = TAG_UTCTIME;

    Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("AEST"));
    cal.add(Calendar.HOUR_OF_DAY, offset);

    StringBuffer now = new StringBuffer();
    now.append(String.valueOf(cal.get(Calendar.YEAR)).substring(2, 4));

    append(now, cal.get(Calendar.MONTH) + 1);
    append(now, cal.get(Calendar.DATE));
    append(now, cal.get(Calendar.HOUR));
    append(now, cal.get(Calendar.MINUTE));

    now.append("Z");
    contents = now.toString().getBytes();
  }

  public UTCTime(String time)
  {
    tagNum = TAG_UTCTIME;
    contents = time.getBytes();
  }

  public static Asn1 decode(byte encoded[], int marks[]) throws Asn1Exception
  {
    UTCTime retval = new UTCTime();
    retval.doDecode(encoded, marks);
    return retval;
  }

  public String getTime()
  {
    return new String(contents);
  }

  public void info(int dep)
  {
    depth = dep+1;
    spit(); System.out.print("UTC TIME ");
    System.out.println(new String(contents));
  }

  // Only handles GMT time currently
  public Date getDate()
  {
    String utc = new String(this.contents);
    Date retval = null;
    if (utc.endsWith ("Z"))
    {
      Calendar cal = Calendar.getInstance ();
      int year, month, date, hour, minute, second;
      switch (utc.length ())
      {
        //YYMMDDhhmmZ
        case (11):
          year = 1900 + java.lang.Integer.parseInt (utc.substring (0, 2));
          month = java.lang.Integer.parseInt (utc.substring (2, 4)) - 1;
          date = java.lang.Integer.parseInt (utc.substring (4, 6));
          hour = java.lang.Integer.parseInt (utc.substring (6, 8));
          minute = java.lang.Integer.parseInt (utc.substring (8, 10));
          cal.set (year, month, date, hour, minute);
          break;

        //YYMMDDhhmmssZ
        case (13):
          year = 1900 + java.lang.Integer.parseInt (utc.substring (0, 2));
          month = java.lang.Integer.parseInt (utc.substring (2, 4)) - 1;
          date = java.lang.Integer.parseInt (utc.substring (4, 6));
          hour = java.lang.Integer.parseInt (utc.substring (6, 8));
          minute = java.lang.Integer.parseInt (utc.substring (8, 10));
          second = java.lang.Integer.parseInt (utc.substring (10, 12));
          cal.set (year, month, date, hour, minute, second);
          break;

        default: ;
      }
       retval = cal.getTime ();
    }
    return retval;
  }

  private void append(StringBuffer sb, int number)
  {
    if (number < 10)
      sb.append("0" + number);
    else
      sb.append(number);
  }
}
