//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.cms.v1;

import java.io.ByteArrayInputStream;
import java.util.Vector;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import com.dstc.security.x509.X509CertImpl;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.asn1.Asn1Exception;

/**
 * <p> Implements the ASN.1 structure CertificateSet.
 *
 * <pre>
 *     CertificateSet ::= SET OF CertificateChoices
 *   
 *     CertificateChoices ::= CHOICE {
 *        certificate Certificate,  -- See X.509
 *        extendedCertificate [0] IMPLICIT ExtendedCertificate,  -- Obsolete
 *        attrCert [1] IMPLICIT AttributeCertificate }  -- See X.509 and X9.57
 *
 * </pre>
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class CertificateSet extends SetOf
{
  private Set certs;

  /**
   * Constructs a CertificateSet from a Set of X509Certificate
   */
  public CertificateSet(Set certs) throws Asn1Exception, CertificateException
  {
    this.certs = certs;

    Iterator it = this.certs.iterator();
    while (it.hasNext())
    {
      Asn1 der = Asn1.decode(((X509Certificate)it.next()).getEncoded());
      addComponent(der);
    }
  }

  /**
   * Constructs a CertificateSet from a DER encoding
   */
  public CertificateSet(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    try
    {
      CertificateFactory certFact = CertificateFactory.getInstance("X509");
      ByteArrayInputStream bais;

      certs = new HashSet();
      for (int i=0; i<components.size(); i++)
      {
        
        bais 
         = new ByteArrayInputStream(((Asn1)components.elementAt(i)).encode());
        X509Certificate cert
          = (X509Certificate)certFact.generateCertificate(bais);
        certs.add(cert);
      }
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  /**
   * Return the Set of X509Certificates
   */
  public Set getCerts()
  {
    return this.certs;
  }
}
