//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.OctetString;

/**
 * <p> Implements the ASN.1 structure EncapsulatedContentInfo.
 *
 *     EncapsulatedContentInfo ::= SEQUENCE {
 *        eContentType ContentType,
 *        eContent [0] EXPLICIT OCTET STRING OPTIONAL }
 *      
 *     ContentType ::= OBJECT IDENTIFIER
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class EncapContentInfo extends Sequence
{
  private Oid eContentType;
  private byte[] eContent;

  /**
   * Constructs an EncapContentInfo from a content type and the content
   */
  public EncapContentInfo(String contentType, byte content[])
  {
    this.eContentType = new Oid(contentType);
    addComponent(this.eContentType);

    if (content == null) return;

    this.eContent = content;
    Explicit exp = new Explicit(Asn1.TAG_CLASS_CONTEXT, 0);
    exp.addComponent(new OctetString(content));
    addComponent(exp);
  }

  /**
   * Constructs an EncapContentInfo from a DER encoding
   */
  public EncapContentInfo(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
    int i=0;

    this.eContentType = (Oid)components.elementAt(i++);
    
    if (i >= components.size()) return;
    Explicit exp = (Explicit)components.elementAt(i);
    this.eContent = ((OctetString)exp.getComponent()).getBytes();
  }

  /**
   * Returns the content type as an Oid
   */
  public Oid getContentType()
  {
    return this.eContentType;
  }

  /**
   * Returns the content as a array of bytes
   */
  public byte[] getContent()
  {
    return eContent;
  }
}
