//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.cms.v1;

import java.math.BigInteger;
import java.security.cert.X509Certificate;

import com.dstc.security.x509.X509CertImpl;
import com.dstc.security.x509.X500Name;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;

/**
 * <p> Implements the ASN.1 structure IssuerAndSerialNumber.
 *
 * <pre>
 *      IssuerAndSerialNumber ::= SEQUENCE {
 *        issuer Name,
 *        serialNumber CertificateSerialNumber }
 *
 *      CertificateSerialNumber ::= INTEGER
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class IssuerAndSerialNumber extends Sequence
{
  private X500Name issuer;
  private BigInteger serialNumber;

  /**
   * Constructs an IssuerAndSerialNumber from an X509Certificate
   */
  public IssuerAndSerialNumber(X509Certificate cert)
  {
    try
    {
      this.issuer 
        = (X500Name)(new X509CertImpl(cert.getEncoded())).getIssuerDN();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }

    //this.issuer = new X500Name(cert.getIssuerDN().getName());
    addComponent(this.issuer);

    this.serialNumber = cert.getSerialNumber();
    addComponent(new com.dstc.security.asn1.Integer(this.serialNumber));
  }

  /**
   * Constructs an IssuerAndSerialNumber from a DER encoding
   */
  public IssuerAndSerialNumber(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);

    this.issuer = new X500Name(((Asn1)components.elementAt(0)).encode());

    this.serialNumber = 
      ((com.dstc.security.asn1.Integer)components.elementAt(1)).getBigInteger();
  }

  public BigInteger getSerialNumber()
  {
    return this.serialNumber;
  }

  public X500Name getIssuer()
  {
    return this.issuer;
  }

  public boolean equals(IssuerAndSerialNumber other)
  {
    if (this.serialNumber.equals(other.getSerialNumber()) &&
        this.issuer.equals(other.getIssuer()))
      return true;
    else
      return false;
  }
}
