//////////////////////////////////////////////////////////////////////////// 
// 
// Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1993, 1994, 1995.
// Unpublished work.  All Rights Reserved.
// 
// The software contained on this media is the property of the
// DSTC Pty Ltd.  Use of this software is strictly in accordance
// with the license agreement in the accompanying LICENSE.DOC 
// file. If your distribution of this software does not contain 
// a LICENSE.DOC file then you have no rights to use this 
// software in any manner and should contact DSTC at the address 
// below to determine an appropriate licensing arrangement.
// 
//      DSTC Pty Ltd
//      Level 7, GP South
//      University of Queensland
//      St Lucia, 4072
//      Australia
//      Tel: +61 7 3365 4310
//      Fax: +61 7 3365 4311
//      Email: jcsi@dstc.qut.edu.au
// 
// This software is being provided "AS IS" without warranty of
// any kind.  In no event shall DSTC Pty Ltd be liable for
// damage of any kind arising out of or in connection with
// the use or performance of this software.
// 
//////////////////////////////////////////////////////////////////////////// 

package com.dstc.security.cms.v1;

import java.util.Vector;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Asn1;
import com.dstc.security.cms.v1.CertificateSet;

/**
 * <p>Implements the ASN.1 structure OriginatorInfo.
 *
 * <pre>
 *     OriginatorInfo ::= SEQUENCE {
 *        certs [0] IMPLICIT CertificateSet OPTIONAL,
 *        crls [1] IMPLICIT CertificateRevocationLists OPTIONAL }
 *
 * </pre>
 *
 * @version 0.98, 98/07/01
 * @author Ming Yung
 */
public final class OriginatorInfo extends Sequence
{
  private CertificateSet certs;

  /**
   * Constructs an OriginatorInfo from a DER encoding
   */
  public OriginatorInfo(byte encoded[]) throws Asn1Exception
  {
    doDecode(encoded);
    int i = 0;
    
    this.certs = 
      new CertificateSet(((Asn1)components.elementAt(i++)).encode());
  }

  /**
   * Returns the CertificateSet in this OriginatorInfo
   */
  public CertificateSet getCertificateSet()
  {
    return this.certs;
  }
}
